/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceRegistry;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceRequestClientResolver;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

@ApplicationScoped
final class KnativeServerlessWorkflowCustomFunction {
    static final String CLOUD_EVENT_PROPERTY_NAME = "asCloudEvent";
    static final String PATH_PROPERTY_NAME = "path";
    private final KnativeServiceRegistry knativeServiceRegistry;
    private final KnativeServiceRequestClientResolver knativeServiceRequestClientResolver;

    @Inject
    KnativeServerlessWorkflowCustomFunction(KnativeServiceRegistry knativeServiceRegistry, KnativeServiceRequestClientResolver knativeServiceRequestClientResolver) {
        this.knativeServiceRegistry = knativeServiceRegistry;
        this.knativeServiceRequestClientResolver = knativeServiceRequestClientResolver;
    }

    JsonNode execute(String processInstanceId, Map<String, Object> metadata, Map<String, Object> arguments) {
        URI serviceAddress = this.getServiceAddress((String)metadata.get("operation"));
        String path = metadata.getOrDefault(PATH_PROPERTY_NAME, "/").toString();
        return this.knativeServiceRequestClientResolver.resolve(metadata).execute(processInstanceId, serviceAddress, path, arguments);
    }

    private URI getServiceAddress(String knativeServiceName) {
        return this.knativeServiceRegistry.getServiceAddress(knativeServiceName).orElseThrow(() -> new WorkItemExecutionException("The Knative service '" + knativeServiceName + "' could not be found."));
    }
}

