/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.addons.quarkus.k8s.discovery.KnativeServiceDiscovery;
import org.kie.kogito.addons.quarkus.k8s.discovery.KnativeServiceUri;
import org.kie.kogito.addons.quarkus.k8s.discovery.VanillaKubernetesResourceDiscovery;
import org.kie.kogito.addons.quarkus.k8s.discovery.VanillaKubernetesResourceUri;

@ApplicationScoped
final class KnativeServiceRegistry {
    private final Map<String, URI> services = new ConcurrentHashMap<String, URI>();
    private final KnativeServiceDiscovery knativeServiceDiscovery;
    private final VanillaKubernetesResourceDiscovery vanillaKubernetesResourceDiscovery;

    @Inject
    KnativeServiceRegistry(KnativeServiceDiscovery knativeServiceDiscovery, VanillaKubernetesResourceDiscovery vanillaKubernetesResourceDiscovery) {
        this.knativeServiceDiscovery = knativeServiceDiscovery;
        this.vanillaKubernetesResourceDiscovery = vanillaKubernetesResourceDiscovery;
    }

    Optional<URI> getServiceAddress(String serviceName) {
        Function<String, Optional> function;
        String[] splitServiceName = serviceName.split("/");
        switch (splitServiceName.length) {
            case 1: {
                function = k -> this.knativeServiceDiscovery.query(new KnativeServiceUri(null, serviceName));
                break;
            }
            case 2: {
                function = k -> this.knativeServiceDiscovery.query(new KnativeServiceUri(splitServiceName[0], splitServiceName[1]));
                break;
            }
            default: {
                function = k -> this.vanillaKubernetesResourceDiscovery.query(VanillaKubernetesResourceUri.parse((String)k));
            }
        }
        return Optional.ofNullable(this.services.computeIfAbsent(serviceName, k -> ((Optional)function.apply((String)k)).orElse(null)));
    }
}

