/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.CloudEventKnativeServiceRequestClient;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceRequestClient;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.PlainJsonKnativeServiceRequestClient;

@ApplicationScoped
class KnativeServiceRequestClientResolver {
    private final CloudEventKnativeServiceRequestClient cloudEventClient;
    private final PlainJsonKnativeServiceRequestClient plainJsonClient;

    @Inject
    KnativeServiceRequestClientResolver(CloudEventKnativeServiceRequestClient cloudEventClient, PlainJsonKnativeServiceRequestClient plainJsonClient) {
        this.cloudEventClient = cloudEventClient;
        this.plainJsonClient = plainJsonClient;
    }

    KnativeServiceRequestClient resolve(Map<String, Object> metadata) {
        if (KnativeServiceRequestClientResolver.isCloudEvent(metadata)) {
            return this.cloudEventClient;
        }
        return this.plainJsonClient;
    }

    private static boolean isCloudEvent(Map<String, Object> metadata) {
        return Boolean.parseBoolean(metadata.getOrDefault("asCloudEvent", "false").toString());
    }
}

