/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.cloudevents.SpecVersion;
import io.quarkus.test.junit.QuarkusTest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.CloudEventKnativeServiceRequestClient;
import org.kie.kogito.event.cloudevents.utils.InvalidCloudEventException;

@QuarkusTest
class CloudEventKnativeServiceRequestClientTest {
    private static WireMockServer wireMockServer;
    @Inject
    CloudEventKnativeServiceRequestClient client;

    CloudEventKnativeServiceRequestClientTest() {
    }

    @Test
    void cloudEventWithoutIdMustHaveGeneratedId() {
        CloudEventKnativeServiceRequestClientTest.mockServer();
        String processInstanceId = "process1";
        String source = "https://localhost:8080";
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", 1.0, "source", source, "type", "org.kie.kogito.test", "data", Map.of("org", "Acme", "project", "Kogito"));
        this.client.sendRequest(processInstanceId, URI.create(wireMockServer.baseUrl()), "/cloud-event", cloudEvent);
        String expectedCloudEventId = CloudEventKnativeServiceRequestClient.generateCloudEventId((String)processInstanceId, cloudEvent);
        wireMockServer.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/cloud-event")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.id", (StringValuePattern)WireMock.equalTo((String)expectedCloudEventId))).withHeader("Content-Type", WireMock.equalTo((String)"application/cloudevents+json; charset=UTF-8")));
    }

    @Test
    void cloudEventWithIdMustBeSentAsIs() {
        CloudEventKnativeServiceRequestClientTest.mockServer();
        String processInstanceId = "process1";
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", 1.0, "id", 42, "source", "https://localhost:8080", "type", "org.kie.kogito.test", "data", Map.of("org", "Acme", "project", "Kogito"));
        this.client.sendRequest(processInstanceId, URI.create(wireMockServer.baseUrl()), "/cloud-event", cloudEvent);
        wireMockServer.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/cloud-event")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.id", (StringValuePattern)WireMock.equalTo((String)"42"))).withHeader("Content-Type", WireMock.equalTo((String)"application/cloudevents+json; charset=UTF-8")));
    }

    @Test
    void invalidCloudEventMustThrowException() {
        String processInstanceId = "process1";
        HashMap<String, String> cloudEvent = new HashMap<String, String>();
        cloudEvent.put("specversion", SpecVersion.V1.toString());
        cloudEvent.put("id", "abc-123");
        cloudEvent.put("source", "/myapp");
        cloudEvent.put("type", "com.example.someevent");
        cloudEvent.put("datacontenttype", "application/json");
        cloudEvent.put("time", "invalid");
        cloudEvent.put("data", "{\"foo\":\"bar\"}");
        URI uri = URI.create(wireMockServer.baseUrl());
        Assertions.assertThatExceptionOfType(InvalidCloudEventException.class).isThrownBy(() -> this.client.sendRequest(processInstanceId, uri, "/cloud-event", cloudEvent));
    }

    private static void mockServer() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/cloud-event")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/cloudevents+json; charset=UTF-8"}).withJsonBody(JsonNodeFactory.instance.objectNode().put("message", "CloudEvents are awesome!").set("object", (JsonNode)JsonNodeFactory.instance.objectNode().put("long", 42L).put("String", "Knowledge is everything")))));
    }

    private static void createWiremockServer() {
        wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        wireMockServer.start();
    }

    @BeforeAll
    static void beforeAll() {
        CloudEventKnativeServiceRequestClientTest.createWiremockServer();
    }

    @AfterAll
    static void afterAll() {
        if (wireMockServer != null) {
            wireMockServer.stop();
        }
    }
}

