/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.cloudevents.SpecVersion;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.kubernetes.client.KubernetesTestServer;
import io.quarkus.test.kubernetes.client.WithKubernetesTestServer;
import io.smallrye.mutiny.TimeoutException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.addons.quarkus.k8s.test.utils.KnativeResourceDiscoveryTestUtil;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServerlessWorkflowCustomFunction;
import org.kie.kogito.event.cloudevents.utils.InvalidCloudEventException;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

@QuarkusTest
@WithKubernetesTestServer
class KnativeServerlessWorkflowCustomFunctionTest {
    private static final String UNUSED = "unused";
    private static final String NAMESPACE = "test";
    private static final String SERVICENAME = "serverless-workflow-greeting-quarkus";
    private static final String NAMESPACE_SERVICENAME = "test/serverless-workflow-greeting-quarkus";
    private static final String GVK = "services.v1.serving.knative.dev";
    private static final String GVK_SERVICENAME = "services.v1.serving.knative.dev/serverless-workflow-greeting-quarkus";
    private static final String GVK_NAMESPACE_SERVICENAME = "services.v1.serving.knative.dev/test/serverless-workflow-greeting-quarkus";
    private static final String CLOUD_EVENT_PATH = "/cloud-event";
    private static String remoteServiceUrl;
    @KubernetesTestServer
    KubernetesServer mockServer;
    @ConfigProperty(name="kogito.addon.knative-serving.request-timeout")
    Long requestTimeout;
    @Inject
    KnativeServerlessWorkflowCustomFunction knativeServerlessWorkflowCustomFunction;
    private static WireMockServer wireMockServer;

    KnativeServerlessWorkflowCustomFunctionTest() {
    }

    @BeforeAll
    static void beforeAll() {
        KnativeServerlessWorkflowCustomFunctionTest.createWiremockServer();
    }

    @BeforeEach
    void beforeEach() {
        KnativeResourceDiscoveryTestUtil.createServiceIfNotExists((KubernetesServer)this.mockServer, (String)remoteServiceUrl, (String)"knative/quarkus-greeting.yaml", (String)NAMESPACE, (String)SERVICENAME);
    }

    @AfterAll
    static void afterAll() {
        if (wireMockServer != null) {
            wireMockServer.stop();
        }
    }

    private static void createWiremockServer() {
        wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        wireMockServer.start();
        remoteServiceUrl = wireMockServer.baseUrl();
    }

    private void mockExecuteTimeoutEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/timeout")).willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(this.requestTimeout.intValue() + 500)).withStatus(200)));
    }

    private void mockExecute404Endpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/non_existing_path")).willReturn(WireMock.aResponse().withStatus(404)));
    }

    private void mockExecuteWithQueryParametersEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/hello")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withJsonBody((JsonNode)JsonNodeFactory.instance.objectNode().put("message", "Hello Kogito"))));
    }

    private void mockExecuteWithParametersEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)WireMock.equalToJson((String)JsonNodeFactory.instance.objectNode().put("org", "Acme").put("project", "Kogito").toString())).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withJsonBody(JsonNodeFactory.instance.objectNode().put("message", "Kogito is awesome!").set("object", (JsonNode)JsonNodeFactory.instance.objectNode().put("long", 42L).put("String", "Knowledge is everything")))));
    }

    private void mockExecuteWithArray() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)WireMock.equalToJson((String)JsonNodeFactory.instance.arrayNode().add("Javierito").add("Pepito").toString())).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withJsonBody((JsonNode)JsonNodeFactory.instance.arrayNode().add(23).add(24))));
    }

    private void mockExecuteCloudEventWithParametersEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)CLOUD_EVENT_PATH)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/cloudevents+json; charset=UTF-8"}).withJsonBody(JsonNodeFactory.instance.objectNode().put("message", "CloudEvents are awesome!").set("object", (JsonNode)JsonNodeFactory.instance.objectNode().put("long", 42L).put("String", "Knowledge is everything")))));
    }

    private void mockExecuteWithEmptyParametersEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withJsonBody((JsonNode)JsonNodeFactory.instance.objectNode().put("org", "Acme").put("project", "Kogito"))));
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeWithEmptyParameters(String operation) {
        this.mockExecuteWithEmptyParametersEndpoint();
        JsonNode output = this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation, Map.of());
        ObjectNode expected = JsonNodeFactory.instance.objectNode().put("org", "Acme").put("project", "Kogito");
        Assertions.assertThat((Iterable)output).isEqualTo((Object)expected);
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeWithParameters(String operation) {
        this.mockExecuteWithParametersEndpoint();
        Map<String, String> parameters = Map.of("org", "Acme", "project", "Kogito");
        JsonNode output = this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation, parameters);
        JsonNode expected = JsonNodeFactory.instance.objectNode().put("message", "Kogito is awesome!").set("object", (JsonNode)JsonNodeFactory.instance.objectNode().put("long", 42L).put("String", "Knowledge is everything"));
        Assertions.assertThat((Iterable)output).hasToString(expected.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeWithArray(String operation) {
        this.mockExecuteWithArray();
        Assertions.assertThat((Iterable)this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation, Map.of("ContentData", List.of("Javierito", "Pepito")))).hasToString(JsonNodeFactory.instance.arrayNode().add(23).add(24).toString());
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeWithCloudEventWithIdAsPlainJson(String operation) {
        this.mockExecuteWithParametersEndpoint();
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", 1.0, "id", 42, "source", "https://localhost:8080", "type", "org.kie.kogito.test", "data", Map.of("org", "Acme", "project", "Kogito"));
        String processInstanceId = Instant.now().toString();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.knativeServerlessWorkflowCustomFunction.execute(processInstanceId, operation, cloudEvent)).withMessage("A Knative custom function argument cannot be a CloudEvent when the 'asCloudEvent' property are not set to 'true'");
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeWithCloudEventWithoutIdAsPlainJson(String operation) {
        this.mockExecuteWithParametersEndpoint();
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", 1.0, "source", "https://localhost:8080", "type", "org.kie.kogito.test", "data", Map.of("org", "Acme", "project", "Kogito"));
        String processInstanceId = Instant.now().toString();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.knativeServerlessWorkflowCustomFunction.execute(processInstanceId, operation, cloudEvent)).withMessage("A Knative custom function argument cannot be a CloudEvent when the 'asCloudEvent' property are not set to 'true'");
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeWithCloudEventThatHasOnlyIdMissingAsPlainJson(String operation) {
        this.mockExecuteWithParametersEndpoint();
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", 1.0, "source", "https://localhost:8080", "type", "org.kie.kogito.test", "data", Map.of("org", "Acme", "project", "Kogito"));
        String processInstanceId = Instant.now().toString();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.knativeServerlessWorkflowCustomFunction.execute(processInstanceId, operation, cloudEvent)).withMessage("A Knative custom function argument cannot be a CloudEvent when the 'asCloudEvent' property are not set to 'true'");
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeCloudEvent(String operation) {
        this.mockExecuteCloudEventWithParametersEndpoint();
        String source = "https://localhost:8080";
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", 1.0, "id", 42, "source", source, "type", "org.kie.kogito.test", "data", Map.of("org", "Acme", "project", "Kogito"));
        String processInstanceId = Instant.now().toString();
        JsonNode output = this.knativeServerlessWorkflowCustomFunction.execute(processInstanceId, operation + "?asCloudEvent=true&path=/cloud-event", cloudEvent);
        JsonNode expected = JsonNodeFactory.instance.objectNode().put("message", "CloudEvents are awesome!").set("object", (JsonNode)JsonNodeFactory.instance.objectNode().put("long", 42L).put("String", "Knowledge is everything"));
        Assertions.assertThat((Iterable)output).hasToString(expected.toString());
        wireMockServer.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)CLOUD_EVENT_PATH)).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.id", (StringValuePattern)WireMock.equalTo((String)"42"))).withHeader("Content-Type", WireMock.equalTo((String)"application/cloudevents+json; charset=UTF-8")));
    }

    @Test
    void executeCloudEventWithMissingIdShouldNotThrowException() {
        this.mockExecuteCloudEventWithParametersEndpoint();
        String source = "https://localhost:8080";
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", 1.0, "source", source, "type", "org.kie.kogito.test", "data", Map.of("org", "Acme", "project", "Kogito"));
        String operation = "serverless-workflow-greeting-quarkus?asCloudEvent=true&path=/cloud-event";
        Assertions.assertThatNoException().isThrownBy(() -> this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation, cloudEvent));
    }

    @Test
    void executeWithInvalidCloudEvent() {
        Map<String, Map<String, String>> cloudEvent = Map.of("specversion", SpecVersion.V1.toString(), "source", "https://localhost:8080", "data", Map.of("org", "Acme", "project", "Kogito"));
        String operation = "serverless-workflow-greeting-quarkus?asCloudEvent=true&path=/cloud-event";
        Assertions.assertThatExceptionOfType(InvalidCloudEventException.class).isThrownBy(() -> this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation, cloudEvent));
    }

    @ParameterizedTest
    @MethodSource(value={"possibleUriFormats"})
    void executeWithQueryParameters(String operation) {
        this.mockExecuteWithQueryParametersEndpoint();
        JsonNode output = this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation + "?path=/hello", Map.of());
        ObjectNode expected = JsonNodeFactory.instance.objectNode().put("message", "Hello Kogito");
        Assertions.assertThat((Iterable)output).isEqualTo((Object)expected);
    }

    @Test
    void execute404() {
        this.mockExecute404Endpoint();
        Map parameters = Map.of();
        String operation = "serverless-workflow-greeting-quarkus?path=/non_existing_path";
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation, parameters)).isInstanceOf(WorkItemExecutionException.class)).extracting("errorCode").isEqualTo((Object)"404");
    }

    @Test
    void executeTimeout() {
        this.mockExecuteTimeoutEndpoint();
        Map payload = Map.of();
        String operation = "serverless-workflow-greeting-quarkus?path=/timeout";
        Assertions.assertThatExceptionOfType(TimeoutException.class).isThrownBy(() -> this.knativeServerlessWorkflowCustomFunction.execute(UNUSED, operation, payload));
    }

    private static Stream<Arguments> possibleUriFormats() {
        return Stream.of(Arguments.of((Object[])new Object[]{SERVICENAME}), Arguments.of((Object[])new Object[]{NAMESPACE_SERVICENAME}), Arguments.of((Object[])new Object[]{GVK_SERVICENAME}), Arguments.of((Object[])new Object[]{GVK_NAMESPACE_SERVICENAME}));
    }
}

