/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.addons.k8s.resource.catalog.DefaultKubernetesServiceCatalogFactory;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesProtocol;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalog;
import org.kie.kogito.addons.k8s.resource.catalog.KubernetesServiceCatalogKey;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceRequestClientResolver;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.Operation;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

@ApplicationScoped
final class KnativeServerlessWorkflowCustomFunction {
    private final KubernetesServiceCatalog kubernetesServiceCatalog;
    private final KnativeServiceRequestClientResolver knativeServiceRequestClientResolver;

    @Inject
    KnativeServerlessWorkflowCustomFunction(Instance<KubernetesServiceCatalog> kubernetesServiceCatalog, KnativeServiceRequestClientResolver knativeServiceRequestClientResolver) {
        this.kubernetesServiceCatalog = kubernetesServiceCatalog.isUnsatisfied() ? DefaultKubernetesServiceCatalogFactory.createKubernetesServiceCatalog() : (KubernetesServiceCatalog)kubernetesServiceCatalog.get();
        this.knativeServiceRequestClientResolver = knativeServiceRequestClientResolver;
    }

    JsonNode execute(String processInstanceId, String operationString, Map<String, Object> arguments) {
        URI serviceAddress = this.getServiceAddress(operationString);
        Operation operation = Operation.parse(operationString);
        return this.knativeServiceRequestClientResolver.resolve(operation).execute(processInstanceId, serviceAddress, operation.getPath(), arguments);
    }

    private URI getServiceAddress(String operation) {
        String service = operation.split("\\?")[0];
        return (URI)this.kubernetesServiceCatalog.getServiceAddress(new KubernetesServiceCatalogKey(KubernetesProtocol.KNATIVE, service)).orElseThrow(() -> new WorkItemExecutionException("The Knative service '" + service + "' could not be found."));
    }
}

