/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.process.workitem.WorkItemExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class KnativeServiceRequestClient {
    private static final Logger logger = LoggerFactory.getLogger(KnativeServiceRequestClient.class);
    protected static final long DEFAULT_REQUEST_TIMEOUT_VALUE = 10000L;
    static final String APPLICATION_CLOUDEVENTS_JSON_CHARSET_UTF_8 = "application/cloudevents+json; charset=UTF-8";
    static final String REQUEST_TIMEOUT_PROPERTY_NAME = "kogito.addon.knative-serving.request-timeout";

    KnativeServiceRequestClient() {
    }

    JsonNode execute(String processInstanceId, URI serviceAddress, String path, Map<String, Object> payload) {
        Objects.requireNonNull(serviceAddress, "serviceAddress is a mandatory parameter");
        Objects.requireNonNull(path, "path is a mandatory parameter");
        return this.sendRequest(processInstanceId, serviceAddress, path, payload);
    }

    protected final JsonNode responseAsJsonObject(HttpResponse<Buffer> response) {
        if (logger.isDebugEnabled()) {
            logger.debug("Response - status code: {}, body: {}", (Object)response.statusCode(), (Object)response.bodyAsString());
        }
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            throw new WorkItemExecutionException(Integer.toString(response.statusCode()), response.statusMessage());
        }
        return this.getJsonNode(Json.decodeValue((io.vertx.core.buffer.Buffer)((Buffer)response.body()).getDelegate()));
    }

    private JsonNode getJsonNode(Object json) {
        if (json instanceof JsonObject) {
            return JsonObjectUtils.fromValue((Object)((JsonObject)json).getMap());
        }
        if (json instanceof JsonArray) {
            ArrayNode jsonArray = ObjectMapperFactory.listenerAware().createArrayNode();
            for (Object item : (JsonArray)json) {
                jsonArray.add(this.getJsonNode(item));
            }
            return jsonArray;
        }
        return JsonObjectUtils.fromValue((Object)json);
    }

    protected abstract JsonNode sendRequest(String var1, URI var2, String var3, Map<String, Object> var4);
}

