/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import java.util.HashMap;
import java.util.Objects;

class Operation {
    static final String CLOUD_EVENT_PARAMETER_NAME = "asCloudEvent";
    static final String PATH_PARAMETER_NAME = "path";
    private final String service;
    private final String path;
    private final boolean isCloudEvent;

    private Operation(Builder builder) {
        this.service = Objects.requireNonNull(builder.service);
        this.path = builder.path != null ? builder.path : "/";
        this.isCloudEvent = builder.isCloudEvent;
    }

    String getService() {
        return this.service;
    }

    String getPath() {
        return this.path;
    }

    boolean isCloudEvent() {
        return this.isCloudEvent;
    }

    static Operation parse(String value) {
        String[] parts = value.split("\\?", 2);
        String[] query = parts.length > 1 ? parts[1].split("&") : new String[]{};
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : query) {
            String[] pair = param.split("=", 2);
            params.put(pair[0], pair.length > 1 ? pair[1] : "");
        }
        return Operation.builder().withService(parts[0]).withPath((String)params.get(PATH_PARAMETER_NAME)).withIsCloudEvent(Boolean.parseBoolean((String)params.get(CLOUD_EVENT_PARAMETER_NAME))).build();
    }

    static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        return this.isCloudEvent == operation.isCloudEvent && Objects.equals(this.service, operation.service) && Objects.equals(this.path, operation.path);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.path, this.isCloudEvent);
    }

    static class Builder {
        private String service;
        private String path;
        private boolean isCloudEvent;

        private Builder() {
        }

        Builder withService(String service) {
            this.service = service;
            return this;
        }

        Builder withPath(String path) {
            this.path = path;
            return this;
        }

        Builder withIsCloudEvent(boolean isCloudEvent) {
            this.isCloudEvent = isCloudEvent;
            return this;
        }

        Operation build() {
            return new Operation(this);
        }
    }
}

