/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceRequestClient;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class PlainJsonKnativeServiceRequestClient
extends KnativeServiceRequestClient {
    private static final Logger logger = LoggerFactory.getLogger(PlainJsonKnativeServiceRequestClient.class);
    static final String CLOUDEVENT_SENT_AS_PLAIN_JSON_ERROR_MESSAGE = "A Knative custom function argument cannot be a CloudEvent when the 'asCloudEvent' property are not set to 'true'";
    private final WebClient webClient;
    private final Duration requestTimeout;

    @Inject
    PlainJsonKnativeServiceRequestClient(Vertx vertx, @ConfigProperty(name="kogito.addon.knative-serving.request-timeout") Optional<Long> requestTimeout) {
        this.webClient = WebClient.create((Vertx)vertx);
        this.requestTimeout = Duration.ofMillis(requestTimeout.orElse(10000L));
    }

    @Override
    protected JsonNode sendRequest(String processInstanceId, URI serviceAddress, String path, Map<String, Object> payload) {
        HttpResponse response;
        HttpRequest request = serviceAddress.getPort() >= 0 ? this.webClient.post(serviceAddress.getPort(), serviceAddress.getHost(), path) : this.webClient.post(serviceAddress.getHost(), path);
        request.ssl(Boolean.valueOf("https".equals(serviceAddress.getScheme())));
        if (payload.isEmpty()) {
            logger.debug("Sending request with empty body - host: {}, port: {}, path: {}", new Object[]{serviceAddress.getHost(), serviceAddress.getPort(), path});
            response = (HttpResponse)request.send().await().atMost(this.requestTimeout);
        } else {
            Object body;
            if (payload.size() == 1 && payload.containsKey("ContentData")) {
                body = payload.get("ContentData");
            } else {
                this.validatePayload(payload);
                body = new JsonObject(payload);
            }
            logger.debug("Sending request with body - host: {}, port: {}, path: {}, body: {}", new Object[]{serviceAddress.getHost(), serviceAddress.getPort(), path, body});
            response = (HttpResponse)request.sendJson(body).await().atMost(this.requestTimeout);
        }
        return this.responseAsJsonObject((HttpResponse<Buffer>)response);
    }

    private void validatePayload(Map<String, Object> payload) {
        List missingAttributes = CloudEventUtils.getMissingAttributes(payload);
        if (missingAttributes.isEmpty() || missingAttributes.size() == 1 && missingAttributes.contains("id")) {
            throw new IllegalArgumentException(CLOUDEVENT_SENT_AS_PLAIN_JSON_ERROR_MESSAGE);
        }
    }

    @PreDestroy
    void preDestroy() {
        this.webClient.close();
    }
}

