/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import java.util.stream.Stream;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.Operation;

class OperationTest {
    OperationTest() {
    }

    public static Stream<Arguments> parseSource() {
        return Stream.of(Arguments.of((Object[])new Object[]{"service", Operation.builder().withService("service").build()}), Arguments.of((Object[])new Object[]{"service?", Operation.builder().withService("service").build()}), Arguments.of((Object[])new Object[]{"service?path=/my_path", Operation.builder().withService("service").withPath("/my_path").build()}), Arguments.of((Object[])new Object[]{"service?asCloudEvent=true", Operation.builder().withService("service").withIsCloudEvent(true).build()}), Arguments.of((Object[])new Object[]{"service?path=/my_path&asCloudEvent=true", Operation.builder().withService("service").withPath("/my_path").withIsCloudEvent(true).build()}));
    }

    @ParameterizedTest
    @MethodSource(value={"parseSource"})
    void parse(String operationValue, Operation expectedOperation) {
        AssertionsForClassTypes.assertThat((Object)Operation.parse((String)operationValue)).isEqualTo((Object)expectedOperation);
    }
}

