/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import io.vertx.core.http.HttpMethod;
import java.util.stream.Stream;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.Operation;

class OperationTest {
    public static final String SERVICE = "service";

    OperationTest() {
    }

    public static Stream<Arguments> parseSource() {
        return Stream.of(Arguments.of((Object[])new Object[]{SERVICE, Operation.builder().withService(SERVICE).build()}), Arguments.of((Object[])new Object[]{"service?", Operation.builder().withService(SERVICE).build()}), Arguments.of((Object[])new Object[]{"service?path=/my_path", Operation.builder().withService(SERVICE).withPath("/my_path").build()}), Arguments.of((Object[])new Object[]{"service?asCloudEvent=true", Operation.builder().withService(SERVICE).withIsCloudEvent(true).build()}), Arguments.of((Object[])new Object[]{"service?method=GET", Operation.builder().withService(SERVICE).withMethod(HttpMethod.GET).build()}), Arguments.of((Object[])new Object[]{"service?method=get", Operation.builder().withService(SERVICE).withMethod(HttpMethod.GET).build()}), Arguments.of((Object[])new Object[]{"service?path=/my_path&asCloudEvent=true", Operation.builder().withService(SERVICE).withPath("/my_path").withIsCloudEvent(true).build()}), Arguments.of((Object[])new Object[]{"service?path=/my_path&asCloudEvent=false&method=GET", Operation.builder().withService(SERVICE).withPath("/my_path").withIsCloudEvent(false).withMethod(HttpMethod.GET).build()}));
    }

    public static Stream<Arguments> invalidOperationSource() {
        return Stream.of(Arguments.of((Object[])new Object[]{Operation.builder().withService(SERVICE).withMethod(HttpMethod.DELETE)}), Arguments.of((Object[])new Object[]{Operation.builder().withService(SERVICE).withIsCloudEvent(true).withMethod(HttpMethod.GET)}));
    }

    @ParameterizedTest
    @MethodSource(value={"parseSource"})
    void parse(String operationValue, Operation expectedOperation) {
        AssertionsForClassTypes.assertThat((Object)Operation.parse((String)operationValue)).isEqualTo((Object)expectedOperation);
    }

    @ParameterizedTest
    @MethodSource(value={"invalidOperationSource"})
    void invalidOperation(Operation.Builder operationBuilder) {
        AssertionsForClassTypes.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> ((Operation.Builder)operationBuilder).build());
    }
}

