/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import io.vertx.core.http.HttpMethod;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

public final class Operation {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.POST, HttpMethod.GET);
    private static final HttpMethod DEFAULT_HTTP_METHOD = HttpMethod.POST;
    static final String CLOUD_EVENT_PARAMETER_NAME = "asCloudEvent";
    static final String PATH_PARAMETER_NAME = "path";
    static final String METHOD_PARAMETER_NAME = "method";
    private final String service;
    private final String path;
    private final boolean isCloudEvent;
    private final HttpMethod httpMethod;

    private Operation(Builder builder) {
        this.service = Objects.requireNonNull(builder.service);
        this.path = builder.path != null ? builder.path : "/";
        this.isCloudEvent = builder.isCloudEvent;
        this.httpMethod = builder.httpMethod;
        Operation.validate(this);
    }

    private static void validate(Operation operation) {
        if (!SUPPORTED_METHODS.contains(operation.getHttpMethod())) {
            throw new UnsupportedOperationException(MessageFormat.format("Knative custom function doesn''t support the {0} HTTP method. Supported methods are: {1}.", operation.getHttpMethod(), SUPPORTED_METHODS));
        }
        if (operation.isCloudEvent() && !operation.getHttpMethod().equals((Object)HttpMethod.POST)) {
            throw new UnsupportedOperationException(MessageFormat.format("Knative custom function can only send CloudEvents through POST method. Method used: {0}", operation.getHttpMethod()));
        }
    }

    public String getService() {
        return this.service;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isCloudEvent() {
        return this.isCloudEvent;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public static Operation parse(String value) {
        String[] parts = value.split("\\?", 2);
        String[] query = parts.length > 1 ? parts[1].split("&") : new String[]{};
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : query) {
            String[] pair = param.split("=", 2);
            params.put(pair[0], pair.length > 1 ? pair[1] : "");
        }
        return Operation.builder().withService(parts[0]).withPath((String)params.get(PATH_PARAMETER_NAME)).withIsCloudEvent(Boolean.parseBoolean((String)params.get(CLOUD_EVENT_PARAMETER_NAME))).withMethod(HttpMethod.valueOf((String)params.getOrDefault(METHOD_PARAMETER_NAME, DEFAULT_HTTP_METHOD.name()).toUpperCase())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        return this.isCloudEvent == operation.isCloudEvent && Objects.equals(this.service, operation.service) && Objects.equals(this.path, operation.path) && Objects.equals(this.httpMethod, operation.httpMethod);
    }

    public String toString() {
        return "Operation{service='" + this.service + "', path='" + this.path + "', isCloudEvent=" + this.isCloudEvent + ", httpMethod=" + this.httpMethod + "}";
    }

    public int hashCode() {
        return Objects.hash(this.service, this.path, this.isCloudEvent, this.httpMethod);
    }

    public static class Builder {
        private String service;
        private String path;
        private boolean isCloudEvent;
        private HttpMethod httpMethod = DEFAULT_HTTP_METHOD;

        private Builder() {
        }

        public Builder withService(String service) {
            this.service = service;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withIsCloudEvent(boolean isCloudEvent) {
            this.isCloudEvent = isCloudEvent;
            return this;
        }

        public Builder withMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Operation build() {
            return new Operation(this);
        }
    }
}

