/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.mock.EnableKnativeMockClient;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.knative.serving.v1.RouteBuilder;
import io.fabric8.knative.serving.v1.RouteFluent;
import io.fabric8.knative.serving.v1.RouteStatus;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.KnativeRouteEndpointDiscovery;

@EnableKnativeMockClient(crud=true)
public class KnativeRouteEndpointDiscoveryTest {
    static KnativeClient knativeClient;

    @Test
    public void testBaseCase() {
        KnativeRouteEndpointDiscovery endpointDiscovery = new KnativeRouteEndpointDiscovery(null);
        endpointDiscovery.setKnativeClient(knativeClient);
        RouteStatus status = new RouteStatus();
        status.setUrl("http://192.168.2.32");
        Route route = ((RouteBuilder)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName("ksvc1")).withNamespace("test")).and()).withStatus(status)).build();
        knativeClient.routes().create((Object)route);
        Optional endpoint = endpointDiscovery.findEndpoint("test", "ksvc1");
        Assertions.assertTrue((boolean)endpoint.isPresent());
        try {
            new URL(((Endpoint)endpoint.get()).getUrl());
        }
        catch (MalformedURLException e) {
            Assertions.fail((String)("The generated URL " + ((Endpoint)endpoint.get()).getUrl() + " is invalid"));
        }
    }

    @Test
    public void testQueryByLabels() {
        KnativeRouteEndpointDiscovery endpointDiscovery = new KnativeRouteEndpointDiscovery(null);
        endpointDiscovery.setKnativeClient(knativeClient);
        Map<String, String> labels = Collections.singletonMap("app", "serverlessapp");
        RouteStatus status = new RouteStatus();
        status.setUrl("http://192.168.2.32");
        Route route = ((RouteBuilder)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withLabels(labels)).withName("ksvc2")).withNamespace("test")).and()).withStatus(status)).build();
        knativeClient.routes().create((Object)route);
        List endpoint = endpointDiscovery.findEndpoint("test", labels);
        Assertions.assertFalse((boolean)endpoint.isEmpty());
        try {
            new URL(((Endpoint)endpoint.get(0)).getUrl());
        }
        catch (MalformedURLException e) {
            Assertions.fail((String)("The generated URL " + ((Endpoint)endpoint.get(0)).getUrl() + " is invalid"));
        }
    }

    @Test
    public void testRouteWithoutStatus() {
        KnativeRouteEndpointDiscovery endpointDiscovery = new KnativeRouteEndpointDiscovery(null);
        endpointDiscovery.setKnativeClient(knativeClient);
        Route route = ((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName("ksvc3")).withNamespace("test")).and()).build();
        knativeClient.routes().create((Object)route);
        Optional endpoint = endpointDiscovery.findEndpoint("test", "ksvc3");
        Assertions.assertTrue((boolean)endpoint.isEmpty());
    }
}

