/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.kubernetes.client.KubernetesTestServer;
import io.quarkus.test.kubernetes.client.WithKubernetesTestServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointDiscovery;

@WithKubernetesTestServer
@QuarkusTest
public class KubernetesServiceEndpointDiscoveryTest {
    @KubernetesTestServer
    KubernetesServer mockServer;
    @Named(value="default")
    @Inject
    EndpointDiscovery endpointDiscovery;

    private void createServiceIfNotExist(String name, Map<String, String> labels, Integer ... ports) {
        if (((ServiceResource)((NonNamespaceOperation)this.mockServer.getClient().services().inNamespace("test")).withName(name)).get() != null) {
            return;
        }
        ArrayList<ServicePort> sPorts = new ArrayList<ServicePort>();
        for (Integer integer : ports) {
            ServicePort port = new ServicePort();
            port.setPort(integer);
            sPorts.add(port);
        }
        Service svc = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name)).withNamespace("test")).withLabels(labels)).and()).withSpec(new ServiceSpec())).build();
        svc.getSpec().setClusterIP("127.0.0.1");
        svc.getSpec().setPorts(sPorts);
        this.mockServer.getClient().services().create((Object)svc);
    }

    @Test
    public void testGetURLOnStandardPort() {
        this.createServiceIfNotExist("svc1", Collections.emptyMap(), 80, 8776);
        Optional endpoint = this.endpointDiscovery.findEndpoint("test", "svc1");
        Assertions.assertTrue((boolean)endpoint.isPresent());
        Assertions.assertFalse((boolean)((Endpoint)endpoint.get()).getUrl().isEmpty());
        try {
            new URL(((Endpoint)endpoint.get()).getUrl());
        }
        catch (MalformedURLException e) {
            Assertions.fail((String)("The generated URL " + ((Endpoint)endpoint.get()).getUrl() + " is invalid"));
        }
    }

    @Test
    public void testGetURLOnRandomPort() {
        this.createServiceIfNotExist("svc2", Collections.singletonMap("app", "test1"), 8778);
        List endpoints = this.endpointDiscovery.findEndpoint("test", Collections.singletonMap("app", "test1"));
        Assertions.assertFalse((boolean)endpoints.isEmpty());
        Assertions.assertFalse((boolean)((Endpoint)endpoints.get(0)).getUrl().isEmpty());
        try {
            new URL(((Endpoint)endpoints.get(0)).getUrl());
        }
        catch (MalformedURLException e) {
            Assertions.fail((String)("The generated URL " + ((Endpoint)endpoints.get(0)).getUrl() + " is invalid"));
        }
    }
}

