/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.addons.quarkus.k8s.KubeConstants;
import org.kie.kogito.addons.quarkus.k8s.KubeResourceDiscovery;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KubeDiscoveryConfigCache {
    private static final Logger logger = LoggerFactory.getLogger(KubeDiscoveryConfigCache.class);
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private final KubeResourceDiscovery kResource;

    KubeDiscoveryConfigCache(KubeResourceDiscovery kResource) {
        this.kResource = kResource;
    }

    Optional<String> get(String configName, String configValue) {
        try {
            if (this.isValidURI(configValue)) {
                String cachedValue = this.cache.computeIfAbsent(configName, k -> this.kResource.query(new KubeURI(configValue)).orElse(null));
                return Optional.ofNullable(cachedValue);
            }
        }
        catch (RuntimeException e) {
            logger.error("Service Discovery has failed on property [{}={}]", new Object[]{configName, configValue, e});
        }
        return Optional.ofNullable(configValue);
    }

    private boolean isValidURI(String value) {
        return value != null && !value.isBlank() && KubeConstants.SUPPORTED_PROTOCOLS.stream().anyMatch(protocol -> value.length() > protocol.length() + 1 && value.startsWith(protocol + ":"));
    }
}

