/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.lang.invoke.MethodHandles;
import org.kie.kogito.addons.quarkus.k8s.KubeDiscoveryConfigCache;
import org.kie.kogito.addons.quarkus.k8s.KubeResourceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeDiscoveryConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private transient KubernetesClient client;
    private final transient KubeDiscoveryConfigCache kubeDiscoveryConfigCache;

    public KubeDiscoveryConfigSourceInterceptor() {
        logger.debug("Configuring k8s client...");
        this.client = new DefaultKubernetesClient();
        this.kubeDiscoveryConfigCache = new KubeDiscoveryConfigCache(new KubeResourceDiscovery(this.client));
    }

    public ConfigValue getValue(ConfigSourceInterceptorContext context, String s) {
        ConfigValue configValue = context.proceed(s);
        if (configValue == null) {
            return null;
        }
        return this.kubeDiscoveryConfigCache.get(configValue.getName(), configValue.getValue()).map(arg_0 -> ((ConfigValue)configValue).withValue(arg_0)).orElse(configValue);
    }
}

