/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.k8s.KnativeResourceDiscovery;
import org.kie.kogito.addons.quarkus.k8s.OpenShiftResourceDiscovery;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.kie.kogito.addons.quarkus.k8s.utils.DeploymentUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.IngressUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.PodUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.ServiceUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.StatefulSetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeResourceDiscovery
implements Serializable {
    private static final long serialVersionUID = 2346322442543423434L;
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private KubernetesClient client;

    public KubeResourceDiscovery(KubernetesClient client) {
        this.client = client;
    }

    public Optional<String> query(KubeURI kubeURI) {
        logger.info("Connected to kubernetes cluster {}, current namespace is {}. Resource name for discovery is {}", new Object[]{this.client.getKubernetesVersion().getGitVersion(), this.client.getNamespace(), kubeURI.getResourceName()});
        if (kubeURI.getNamespace() == null) {
            logger.warn("Namespace is not set, setting namespace to the current context [{}].", (Object)this.client.getNamespace());
            kubeURI.setNamespace(this.client.getNamespace());
        }
        switch (kubeURI.getGvk().getGVK().toLowerCase(Locale.ROOT)) {
            case "v1/service": {
                if (this.isKnative(kubeURI)) {
                    KnativeResourceDiscovery knativeResourceDiscovery = new KnativeResourceDiscovery(this.client);
                    return knativeResourceDiscovery.queryService(kubeURI.getNamespace(), kubeURI.getResourceName()).map(Object::toString);
                }
                return ServiceUtils.queryServiceByName(this.client, kubeURI).map(Object::toString);
            }
            case "serving.knative.dev/v1/service": {
                KnativeResourceDiscovery knativeResourceDiscovery = new KnativeResourceDiscovery(this.client);
                return knativeResourceDiscovery.queryService(kubeURI.getNamespace(), kubeURI.getResourceName()).map(Object::toString);
            }
            case "v1/pod": {
                return PodUtils.queryPodByName(this.client, kubeURI).map(Object::toString);
            }
            case "apps/v1/deployment": {
                return DeploymentUtils.queryDeploymentByName(this.client, kubeURI).map(Object::toString);
            }
            case "apps.openshift.io/v1/deploymentconfig": {
                OpenShiftResourceDiscovery ocpDc = new OpenShiftResourceDiscovery(this.client);
                return ocpDc.queryDeploymentConfigByName(kubeURI).map(Object::toString);
            }
            case "apps/v1/statefulset": {
                return StatefulSetUtils.queryStatefulSetByName(this.client, kubeURI).map(Object::toString);
            }
            case "networking.k8s.io/v1/ingress": {
                return IngressUtils.queryIngressByName(this.client, kubeURI).map(Object::toString);
            }
            case "route.openshift.io/v1/route": {
                OpenShiftResourceDiscovery ocpR = new OpenShiftResourceDiscovery(this.client);
                return ocpR.queryRouteByName(kubeURI).map(Object::toString);
            }
        }
        logger.debug("Resource kind {} is not supported yet.", (Object)kubeURI.getGvk().getGVK());
        return Optional.empty();
    }

    private boolean isKnative(KubeURI kubeURI) {
        return kubeURI.getProtocol().equals("knative");
    }
}

