/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.parser;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.addons.quarkus.k8s.KubeConstants;
import org.kie.kogito.addons.quarkus.k8s.parser.GVK;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeURI {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private String protocol;
    private GVK gvk;
    private String namespace;
    private String resourceName;
    private String rawUrl;
    private String customPortName;
    private Map<String, String> customLabels;

    public KubeURI(String rawKubeURI) {
        String[] protoAndValues = rawKubeURI.split(":");
        if (protoAndValues.length <= 1) {
            logger.error("the provided URI {} is not valid", (Object)rawKubeURI);
        }
        String[] values = protoAndValues[1].split("/");
        this.protocol = protoAndValues[0];
        this.rawUrl = rawKubeURI;
        switch (values.length) {
            case 5: {
                this.gvk = new GVK(values[0], values[1], values[2]);
                this.namespace = values[3];
                this.resourceName = values[values.length - 1];
                break;
            }
            case 4: {
                if (values[0].equals("v1")) {
                    this.gvk = new GVK(values[0], values[1]);
                    this.namespace = values[2];
                } else {
                    this.gvk = new GVK(values[0], values[1], values[2]);
                }
                this.resourceName = values[values.length - 1];
                break;
            }
            case 3: {
                this.gvk = new GVK(values[0], values[1]);
                this.resourceName = values[values.length - 1];
                break;
            }
            case 1: 
            case 2: {
                logger.debug("Custom Functions calls are not yet implemented  for more information please visit https://issues.redhat.com/browse/KOGITO-8443");
                break;
            }
            default: {
                logger.error("KubeURI {} is not valid", (Object)rawKubeURI);
            }
        }
        if (this.rawUrl.contains("?")) {
            this.setAttributes(this.rawUrl);
        }
        if (this.resourceName == null || this.resourceName.isBlank()) {
            throw new IllegalArgumentException("resource name can't be empty");
        }
        if (!KubeConstants.SUPPORTED_PROTOCOLS.contains(this.protocol)) {
            throw new IllegalArgumentException("the provided protocol [" + this.protocol + "] is not supported, supported values are " + KubeConstants.SUPPORTED_PROTOCOLS);
        }
        logger.debug(" KubeURI successfully parsed: {}", (Object)this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public GVK getGvk() {
        return this.gvk;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUrl() {
        return this.rawUrl;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    private void setAttributes(String attrs) {
        block8: for (String str : attrs.split("\\?")[1].split("&")) {
            int indexOf = str.indexOf("=");
            String param = str.substring(0, indexOf);
            String value = str.substring(indexOf + 1);
            switch (param) {
                case "port-name": {
                    this.customPortName = value;
                    continue block8;
                }
                case "labels": {
                    this.customLabels = Arrays.asList(value.split(";")).stream().map(str1 -> str1.split("=")).collect(Collectors.toMap(lblName -> lblName[0], lblValue -> lblValue[1]));
                    continue block8;
                }
                default: {
                    logger.warn("The given parameters {} is not supported", (Object)param);
                }
            }
        }
    }

    public String getCustomPortName() {
        return this.customPortName;
    }

    public Map<String, String> getCustomLabel() {
        return this.customLabels;
    }

    public String toString() {
        return "KubeURI{protocol='" + this.protocol + "', gvk=" + this.gvk.toString() + ", namespace='" + this.namespace + "', resourceName='" + this.resourceName + "', rawUrl='" + this.rawUrl + "', customPortName='" + this.customPortName + "', customLabels=" + this.customLabels + "}";
    }
}

