/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.k8s.utils;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Optional;
import org.kie.kogito.addons.quarkus.k8s.parser.KubeURI;
import org.kie.kogito.addons.quarkus.k8s.utils.PortUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.ServiceUtils;
import org.kie.kogito.addons.quarkus.k8s.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PodUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());

    private PodUtils() {
    }

    public static Optional<URI> queryPodByName(KubernetesClient client, KubeURI kubeURI) {
        Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(kubeURI.getNamespace())).withName(kubeURI.getResourceName())).get();
        if (pod == null) {
            logger.error("Pod {} not found on the {} namespace.", (Object)kubeURI.getResourceName(), (Object)kubeURI.getNamespace());
            return Optional.empty();
        }
        return ServiceUtils.queryServiceByLabelOrSelector(client, pod.getMetadata().getLabels(), null, kubeURI).or(() -> {
            if (pod.getStatus().getPodIP() != null && !pod.getStatus().getPodIP().isBlank()) {
                logger.debug("Returning podIP from pod {}", (Object)pod.getMetadata().getName());
                ContainerPort cPort = PortUtils.findContainerPort(((Container)pod.getSpec().getContainers().get(0)).getPorts(), kubeURI);
                return URIUtils.builder("http", cPort.getContainerPort(), pod.getStatus().getPodIP());
            }
            logger.warn("Didn't find any service for pod {} and pod is not accessible.", (Object)pod.getMetadata().getName());
            return Optional.empty();
        });
    }

    public static Optional<URI> queryPodByOwnerReference(KubernetesClient client, String uid, String namespace, KubeURI kubeURI) {
        Optional<Pod> foundPod = ((PodList)((NonNamespaceOperation)client.pods().inNamespace(namespace)).list()).getItems().stream().filter(pod -> pod.hasOwnerReferenceFor(uid) && !pod.getMetadata().getName().endsWith("deploy")).findFirst().or(() -> {
            logger.warn("not found any pod with owner uid {}", (Object)uid);
            return Optional.empty();
        });
        return foundPod.flatMap(pod -> {
            ContainerPort cPort = PortUtils.findContainerPort(((Container)pod.getSpec().getContainers().get(0)).getPorts(), kubeURI);
            return URIUtils.builder("http", cPort.getContainerPort(), ((Pod)foundPod.get()).getStatus().getPodIP());
        });
    }
}

