/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common.http;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonFormat;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kie.kogito.addon.quarkus.messaging.common.AbstractQuarkusCloudEventReceiver;
import org.kie.kogito.addon.quarkus.messaging.common.http.CloudEventResourceException;
import org.kie.kogito.event.cloudevents.utils.Printer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuarkusCloudEventResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuarkusCloudEventResource.class);
    @Inject
    ObjectMapper objectMapper;
    @Inject
    Instance<AbstractQuarkusCloudEventReceiver> receivers;

    @PostConstruct
    public void setup() {
        this.objectMapper.registerModule((Module)JsonFormat.getCloudEventJacksonModule());
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public CompletionStage<Response> cloudEventListener(CloudEvent payload) {
        String serialized = this.serialize(payload);
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        for (AbstractQuarkusCloudEventReceiver receiver : this.receivers) {
            future = future.thenCompose(e -> receiver.produce(serialized));
        }
        return future.thenApply(r -> Response.ok().type("application/json").build());
    }

    protected String serialize(CloudEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CloudEvent to publish: {}", (Object)Printer.beautify((CloudEvent)event));
        }
        try {
            if (!this.isSupportedContentType(event)) {
                LOGGER.warn("Content-Type of the received CloudEvent '{}' is not supported. Content-type is {}. Assuming application/json.", (Object)event.getType(), (Object)event.getDataContentType());
                if (event.getData() != null) {
                    this.objectMapper.readTree(event.getData().toBytes());
                }
                CloudEvent newEvent = CloudEventBuilder.v1((CloudEvent)event).withDataContentType("application/json").build();
                String newDecodedEvent = this.objectMapper.writeValueAsString((Object)newEvent);
                LOGGER.debug("Decoded event {}", (Object)newDecodedEvent);
                return newDecodedEvent;
            }
            return this.objectMapper.writeValueAsString((Object)event);
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new CloudEventResourceException(event, ex);
        }
    }

    private boolean isSupportedContentType(CloudEvent event) {
        return event.getDataContentType() != null && MediaType.APPLICATION_JSON_TYPE.isCompatible(MediaType.valueOf((String)event.getDataContentType()));
    }
}

