/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.smallrye.reactive.messaging.ce.CloudEventMetadata;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.event.process.ProcessDataEvent;
import org.kie.kogito.services.event.impl.AbstractEventUnmarshaller;

public class QuarkusDefaultEventUnmarshaller
extends AbstractEventUnmarshaller<Message<?>> {
    public QuarkusDefaultEventUnmarshaller(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public <T> T unmarshall(Message<?> message, Class<T> clazz, Class<?> ... parametrizedClasses) throws IOException {
        Optional metadata = message.getMetadata(CloudEventMetadata.class);
        return (T)(metadata.isPresent() ? this.binaryCE((CloudEventMetadata)metadata.get(), message.getPayload(), clazz, parametrizedClasses) : this.unmarshallPayload(message.getPayload(), clazz, parametrizedClasses));
    }

    private Object binaryCE(CloudEventMetadata<?> meta, Object payload, Class<?> clazz, Class<?> ... parametrizedClasses) throws IOException {
        if (ProcessDataEvent.class.isAssignableFrom(clazz)) {
            ProcessDataEvent processDataEvent = new ProcessDataEvent();
            processDataEvent.setData(this.unmarshallPayload(payload, parametrizedClasses[0], new Class[0]));
            return this.addCloudEventInfo(meta, processDataEvent);
        }
        if (CloudEvent.class.isAssignableFrom(clazz)) {
            CloudEventBuilder builder = CloudEventBuilder.fromSpecVersion((SpecVersion)SpecVersion.parse((String)meta.getSpecVersion())).withType(meta.getType()).withSource(meta.getSource()).withId(meta.getId());
            meta.getDataContentType().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withDataContentType(arg_0));
            meta.getDataSchema().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withDataSchema(arg_0));
            meta.getTimeStamp().map(ZonedDateTime::toOffsetDateTime).ifPresent(arg_0 -> ((CloudEventBuilder)builder).withTime(arg_0));
            meta.getSubject().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withSubject(arg_0));
            meta.getExtensions().forEach((k, v) -> this.addExtension(builder, (String)k, v));
            if (payload instanceof byte[]) {
                builder.withData((byte[])payload);
            } else if (payload != null) {
                builder.withData(payload.toString().getBytes());
            }
            return builder.build();
        }
        return this.unmarshallPayload(payload, clazz, parametrizedClasses);
    }

    private void addExtension(CloudEventBuilder builder, String k, Object v) {
        if (v instanceof Number) {
            builder.withExtension(k, (Number)v);
        } else if (v instanceof Boolean) {
            builder.withExtension(k, (Boolean)v);
        } else if (v instanceof byte[]) {
            builder.withExtension(k, (byte[])v);
        } else if (v instanceof URI) {
            builder.withExtension(k, (URI)v);
        } else if (v instanceof OffsetDateTime) {
            builder.withExtension(k, (OffsetDateTime)v);
        } else {
            builder.withExtension(k, v.toString());
        }
    }

    private ProcessDataEvent<?> addCloudEventInfo(CloudEventMetadata<?> meta, ProcessDataEvent<?> event) {
        meta.getDataContentType().ifPresent(arg_0 -> event.setDataContentType(arg_0));
        meta.getDataSchema().ifPresent(arg_0 -> event.setDataSchema(arg_0));
        meta.getSubject().ifPresent(arg_0 -> event.setSubject(arg_0));
        meta.getTimeStamp().map(ZonedDateTime::toOffsetDateTime).ifPresent(arg_0 -> event.setTime(arg_0));
        this.set(() -> meta.getId(), arg_0 -> event.setId(arg_0));
        this.set(() -> meta.getType(), arg_0 -> event.setType(arg_0));
        this.set(() -> meta.getSource(), arg_0 -> event.setSource(arg_0));
        this.set(() -> meta.getSpecVersion(), specVersion -> event.setSpecVersion(SpecVersion.parse((String)specVersion)));
        meta.getExtensions().forEach((arg_0, arg_1) -> event.addExtensionAttribute(arg_0, arg_1));
        return event;
    }

    private <T> void set(Supplier<T> supplier, Consumer<T> consumer) {
        T value = supplier.get();
        if (value != null) {
            consumer.accept(value);
        }
    }
}

