/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kie.kogito.addon.quarkus.messaging.common.QuarkusEmitterController;
import org.kie.kogito.event.KogitoThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusEventThreadPool
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(QuarkusEventThreadPool.class);
    private final Deque<Runnable> overflowBuffer = new LinkedList<Runnable>();
    private final QuarkusEmitterController kogitoEmitter;
    private final String channelName;

    public QuarkusEventThreadPool(int numThreads, int queueSize, QuarkusEmitterController kogitoEmitter, String channelName) {
        super(1, numThreads, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(queueSize));
        this.setThreadFactory((ThreadFactory)new KogitoThreadPoolFactory("kogito-event-executor"));
        this.setRejectedExecutionHandler(new NonBlockingRejectedExecutionHandler());
        this.kogitoEmitter = kogitoEmitter;
        this.channelName = channelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        boolean resume;
        Runnable queued;
        Deque<Runnable> deque = this.overflowBuffer;
        synchronized (deque) {
            queued = this.overflowBuffer.pollFirst();
            resume = queued != null && this.overflowBuffer.isEmpty();
        }
        if (queued != null) {
            logger.trace("Addding runnable {} back to the executor", (Object)queued);
            super.execute(queued);
            if (resume) {
                logger.trace("Resuming emission");
                this.kogitoEmitter.resume(this.channelName);
            }
        }
    }

    private class NonBlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private NonBlockingRejectedExecutionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                logger.trace("Rejecting runnable {}. Stopping emission", (Object)r);
                QuarkusEventThreadPool.this.kogitoEmitter.stop(QuarkusEventThreadPool.this.channelName);
                Deque<Runnable> deque = QuarkusEventThreadPool.this.overflowBuffer;
                synchronized (deque) {
                    QuarkusEventThreadPool.this.overflowBuffer.addLast(r);
                }
            }
        }
    }
}

