/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.quarkus.messaging.common.message.MessageDecoratorProvider;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuarkusCloudEventEmitter<M>
implements EventEmitter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQuarkusCloudEventEmitter.class);
    @Inject
    ConfigBean configBean;
    @Inject
    EventMarshaller<M> marshaller;
    @Inject
    MessageDecoratorProvider messageDecorator;

    public <T> CompletionStage<Void> emit(T e, String type, Optional<Function<T, Object>> processDecorator) {
        logger.debug("publishing event {} for type {}", e, (Object)type);
        Message message = this.messageDecorator.decorate(Message.of((Object)this.marshaller.marshall(this.configBean.useCloudEvents() ? processDecorator.map(d -> d.apply(e)).orElse(e) : e)));
        this.emit(message);
        return (CompletionStage)message.getAck().get();
    }

    protected abstract void emit(Message<M> var1);
}

