/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.cloudevents.Subscription;
import org.kie.kogito.addon.quarkus.messaging.common.QuarkusCloudEventConverter;
import org.kie.kogito.addon.quarkus.messaging.common.QuarkusDataEventConverter;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.CloudEventUnmarshallerFactory;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.EventUnmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuarkusCloudEventReceiver<I>
implements EventReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuarkusCloudEventReceiver.class);
    private Collection<Subscription<DataEvent<?>, Message<I>>> consumers = new CopyOnWriteArrayList();
    private EventUnmarshaller<I> eventDataUnmarshaller;
    private CloudEventUnmarshallerFactory<I> cloudEventUnmarshaller;
    @Inject
    ConfigBean configBean;

    protected void init(EventUnmarshaller<I> eventDataUnmarshaller, CloudEventUnmarshallerFactory<I> cloudEventUnmarshaller) {
        this.eventDataUnmarshaller = eventDataUnmarshaller;
        this.cloudEventUnmarshaller = cloudEventUnmarshaller;
    }

    protected CompletionStage<?> produce(Message<I> message) {
        LOGGER.debug("Received message {}", message);
        return this.produce(message, (v, e) -> {
            LOGGER.debug("Acking message {}", (Object)message);
            message.ack();
            if (e != null) {
                LOGGER.error("Error processing message {}", message.getPayload(), e);
            }
        });
    }

    private CompletionStage<?> produce(Message<I> message, BiConsumer<Object, Throwable> callback) {
        CompletableFuture<Object> result;
        CompletionStage<Object> future = result = CompletableFuture.completedFuture(null);
        for (Subscription subscription : this.consumers) {
            try {
                DataEvent object = (DataEvent)subscription.getConverter().convert(message);
                future = future.thenCompose(f -> (CompletionStage)subscription.getConsumer().apply(object));
            }
            catch (IOException e) {
                LOGGER.info("Error converting event. Exception message is {}", (Object)e.getMessage());
            }
        }
        if (callback != null) {
            future.whenComplete(callback);
        }
        return result;
    }

    public <T> void subscribe(Function<DataEvent<T>, CompletionStage<?>> consumer, Class<T> objectClass) {
        Subscription subscription = new Subscription(consumer, this.configBean.useCloudEvents() ? new QuarkusCloudEventConverter(this.cloudEventUnmarshaller.unmarshaller(objectClass)) : new QuarkusDataEventConverter<I, T>(objectClass, this.eventDataUnmarshaller));
        this.consumers.add(subscription);
    }
}

