/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.DefaultBean;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.kie.kogito.event.CloudEventFactory;
import org.kie.kogito.event.EventMarshaller;
import org.kie.kogito.event.impl.ByteArrayEventMarshaller;
import org.kie.kogito.event.impl.JacksonCloudEventFactory;
import org.kie.kogito.event.impl.NoOpEventMarshaller;
import org.kie.kogito.event.impl.StringEventMarshaller;

@ApplicationScoped
public class EventMarshallerProducer {
    @Inject
    ObjectMapper mapper;
    private EventMarshaller<byte[]> byteMarshaller;

    @PostConstruct
    void init() {
        this.byteMarshaller = new ByteArrayEventMarshaller(this.mapper);
    }

    @Produces
    @DefaultBean
    public EventMarshaller<String> stringEventMarshaller() {
        return new StringEventMarshaller(this.mapper);
    }

    @Produces
    @DefaultBean
    public EventMarshaller<byte[]> byteArrayEventMarshaller() {
        return this.byteMarshaller;
    }

    @Produces
    @DefaultBean
    public EventMarshaller<Object> defaultEventMarshaller() {
        return new NoOpEventMarshaller();
    }

    @Produces
    @DefaultBean
    public CloudEventFactory cloudEventFactory() {
        return new JacksonCloudEventFactory(arg_0 -> this.byteMarshaller.marshall(arg_0));
    }
}

