/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.DefaultBean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.kie.kogito.event.CloudEventUnmarshallerFactory;
import org.kie.kogito.event.EventUnmarshaller;
import org.kie.kogito.event.impl.ByteArrayCloudEventUnmarshallerFactory;
import org.kie.kogito.event.impl.JacksonEventDataUnmarshaller;
import org.kie.kogito.event.impl.ObjectCloudEventUnmarshallerFactory;
import org.kie.kogito.event.impl.StringCloudEventUnmarshallerFactory;

@ApplicationScoped
public class EventUnmarshallerProducer {
    @Inject
    ObjectMapper objectMapper;

    @Produces
    @DefaultBean
    public EventUnmarshaller<Object> objectEventDataConverter() {
        return new JacksonEventDataUnmarshaller(this.objectMapper);
    }

    @Produces
    @DefaultBean
    public EventUnmarshaller<String> stringEventDataConverter() {
        return new JacksonEventDataUnmarshaller(this.objectMapper);
    }

    @Produces
    @DefaultBean
    public EventUnmarshaller<byte[]> bytesEventDataConverter() {
        return new JacksonEventDataUnmarshaller(this.objectMapper);
    }

    @Produces
    @DefaultBean
    public CloudEventUnmarshallerFactory<Object> objectCloudEventConverter() {
        return new ObjectCloudEventUnmarshallerFactory(this.objectMapper);
    }

    @Produces
    @DefaultBean
    public CloudEventUnmarshallerFactory<String> stringCloudEventConverter() {
        return new StringCloudEventUnmarshallerFactory(this.objectMapper);
    }

    @Produces
    @DefaultBean
    public CloudEventUnmarshallerFactory<byte[]> bytesCloudEventConverter() {
        return new ByteArrayCloudEventUnmarshallerFactory(this.objectMapper);
    }
}

