/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.kafka;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.kafka.KafkaPersistenceUtils;
import org.kie.kogito.persistence.kafka.KafkaProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class KafkaProcessInstancesTest {
    KafkaProcessInstances instances;
    String processId = "aProcessId";
    @Mock
    KafkaProducer producer;
    @Mock
    Process process;
    @Mock
    ReadOnlyKeyValueStore<String, byte[]> store;
    @Mock
    ProcessInstanceMarshallerService marshaller;
    String id = UUID.randomUUID().toString();
    String storedId = this.processId + "-" + this.id;

    @BeforeEach
    public void setup() {
        ((Process)Mockito.lenient().doReturn((Object)this.processId).when((Object)this.process)).id();
        this.instances = new KafkaProcessInstances(this.process, this.producer);
        this.instances.setStore(this.store);
        this.instances.setMarshaller(this.marshaller);
    }

    @Test
    public void testProcessInstancesSetup() {
        this.instances = new KafkaProcessInstances(this.process, this.producer);
        Assertions.assertThat((Object)this.instances.getProcess()).isEqualTo((Object)this.process);
        CompletableFuture<Void> async = CompletableFuture.runAsync(() -> this.instances.setStore(this.store));
        Assertions.assertThat((Object)this.instances.getStore()).isNotNull();
        Assertions.assertThat(async).hasNotFailed();
        this.instances.setStore(null);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.instances.getStore()).havingCause().withMessage("Failed to obtain Kafka Store for process: aProcessId");
    }

    @Test
    public void testProcessInstancesRemove() {
        ((KafkaProducer)Mockito.doReturn((Object)Mockito.mock(Future.class)).when((Object)this.producer)).send((ProducerRecord)ArgumentMatchers.any());
        this.instances.remove(this.id);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ProducerRecord.class);
        ((KafkaProducer)Mockito.verify((Object)this.producer)).send((ProducerRecord)captor.capture());
        Assertions.assertThat((Object)((ProducerRecord)captor.getValue()).value()).isNull();
        Assertions.assertThat((Object)((ProducerRecord)captor.getValue()).key()).isEqualTo((Object)this.storedId);
        Assertions.assertThat((String)((ProducerRecord)captor.getValue()).topic()).isEqualTo(KafkaPersistenceUtils.topicName());
    }

    @Test
    public void testProcessInstancesExists() {
        ((ReadOnlyKeyValueStore)Mockito.doReturn((Object)new byte[0]).when(this.store)).get((Object)this.storedId);
        Assertions.assertThat((boolean)this.instances.exists(this.id)).isTrue();
        Assertions.assertThat((boolean)this.instances.exists(UUID.randomUUID().toString())).isFalse();
    }

    @Test
    public void testProcessInstancesFindById() {
        ((ProcessInstanceMarshallerService)Mockito.doReturn((Object)Mockito.mock(ProcessInstance.class)).when((Object)this.marshaller)).unmarshallProcessInstance((byte[])ArgumentMatchers.any(), (Process)ArgumentMatchers.any());
        ((ReadOnlyKeyValueStore)Mockito.doReturn((Object)new byte[0]).when(this.store)).get((Object)this.storedId);
        Assertions.assertThat((Optional)this.instances.findById(this.id)).isPresent();
        Assertions.assertThat((Optional)this.instances.findById(UUID.randomUUID().toString())).isNotPresent();
        ((ProcessInstanceMarshallerService)Mockito.verify((Object)this.marshaller)).unmarshallProcessInstance((byte[])ArgumentMatchers.any(), (Process)ArgumentMatchers.any());
    }

    @Test
    public void testProcessInstancesFindByIdReadOnly() {
        ((ProcessInstanceMarshallerService)Mockito.doReturn((Object)Mockito.mock(ProcessInstance.class)).when((Object)this.marshaller)).unmarshallReadOnlyProcessInstance((byte[])ArgumentMatchers.any(), (Process)ArgumentMatchers.any());
        ((ReadOnlyKeyValueStore)Mockito.doReturn((Object)new byte[0]).when(this.store)).get((Object)this.storedId);
        Assertions.assertThat((Optional)this.instances.findById(this.id, ProcessInstanceReadMode.READ_ONLY)).isPresent();
        Assertions.assertThat((Optional)this.instances.findById(UUID.randomUUID().toString(), ProcessInstanceReadMode.READ_ONLY)).isNotPresent();
        ((ProcessInstanceMarshallerService)Mockito.verify((Object)this.marshaller)).unmarshallReadOnlyProcessInstance((byte[])ArgumentMatchers.any(), (Process)ArgumentMatchers.any());
    }

    @Test
    public void testProcessInstancesValues() {
        KeyValueIterator iterator = (KeyValueIterator)Mockito.mock(KeyValueIterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)iterator.next()).thenReturn(Mockito.mock(KeyValue.class));
        ((ReadOnlyKeyValueStore)Mockito.doReturn((Object)iterator).when(this.store)).prefixScan((Object)((String)ArgumentMatchers.eq((Object)this.processId)), (Serializer)ArgumentMatchers.any());
        Assertions.assertThat((Collection)this.instances.values()).hasSize(1);
        ((ProcessInstanceMarshallerService)Mockito.verify((Object)this.marshaller)).unmarshallReadOnlyProcessInstance((byte[])ArgumentMatchers.any(), (Process)ArgumentMatchers.any());
    }

    @Test
    public void testProcessInstancesValuesReadOnly() {
        KeyValueIterator iterator = (KeyValueIterator)Mockito.mock(KeyValueIterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)iterator.next()).thenReturn(Mockito.mock(KeyValue.class));
        ((ReadOnlyKeyValueStore)Mockito.doReturn((Object)iterator).when(this.store)).prefixScan((Object)((String)ArgumentMatchers.eq((Object)this.processId)), (Serializer)ArgumentMatchers.any());
        Assertions.assertThat((Collection)this.instances.values(ProcessInstanceReadMode.MUTABLE)).hasSize(1);
        ((ProcessInstanceMarshallerService)Mockito.verify((Object)this.marshaller)).unmarshallProcessInstance((byte[])ArgumentMatchers.any(), (Process)ArgumentMatchers.any());
    }

    @Test
    public void testProcessInstancesSize() {
        ((ReadOnlyKeyValueStore)Mockito.doReturn((Object)Mockito.mock(KeyValueIterator.class)).when(this.store)).prefixScan((Object)((String)ArgumentMatchers.eq((Object)this.processId)), (Serializer)ArgumentMatchers.any());
        Assertions.assertThat((Integer)this.instances.size()).isZero();
    }

    @Test
    public void testProcessInstancesUpdate() {
        ((KafkaProducer)Mockito.doReturn((Object)Mockito.mock(Future.class)).when((Object)this.producer)).send((ProducerRecord)ArgumentMatchers.any());
        AbstractProcessInstance instance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        ((ProcessInstanceMarshallerService)Mockito.doReturn((Object)new byte[0]).when((Object)this.marshaller)).marshallProcessInstance((ProcessInstance)instance);
        Mockito.when((Object)instance.status()).thenReturn((Object)1);
        this.instances.update(this.id, (ProcessInstance)instance);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ProducerRecord.class);
        ((KafkaProducer)Mockito.verify((Object)this.producer)).send((ProducerRecord)captor.capture());
        Assertions.assertThat((Object)((ProducerRecord)captor.getValue()).value()).isEqualTo((Object)new byte[0]);
        Assertions.assertThat((Object)((ProducerRecord)captor.getValue()).key()).isEqualTo((Object)this.storedId);
        Assertions.assertThat((String)((ProducerRecord)captor.getValue()).topic()).isEqualTo(KafkaPersistenceUtils.topicName());
        ((AbstractProcessInstance)Mockito.verify((Object)instance)).internalRemoveProcessInstance((Consumer)ArgumentMatchers.any());
        ((ProcessInstanceMarshallerService)Mockito.verify((Object)this.marshaller)).createdReloadFunction((Supplier)ArgumentMatchers.any());
    }

    @Test
    public void testProcessInstancesUpdateException() {
        ((KafkaProducer)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.producer)).send((ProducerRecord)ArgumentMatchers.any());
        AbstractProcessInstance instance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        ((ProcessInstanceMarshallerService)Mockito.doReturn((Object)new byte[0]).when((Object)this.marshaller)).marshallProcessInstance((ProcessInstance)instance);
        Mockito.when((Object)instance.status()).thenReturn((Object)1);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.instances.update(this.id, (ProcessInstance)instance));
    }

    @Test
    public void testProcessInstancesUpdateNotActive() {
        AbstractProcessInstance instance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        Mockito.when((Object)instance.status()).thenReturn((Object)2);
        this.instances.update(this.id, (ProcessInstance)instance);
        ((KafkaProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.never())).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
    }

    @Test
    public void testProcessInstancesCreate() {
        ((KafkaProducer)Mockito.doReturn((Object)Mockito.mock(Future.class)).when((Object)this.producer)).send((ProducerRecord)ArgumentMatchers.any());
        AbstractProcessInstance instance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        ((ProcessInstanceMarshallerService)Mockito.doReturn((Object)new byte[0]).when((Object)this.marshaller)).marshallProcessInstance((ProcessInstance)instance);
        Mockito.when((Object)instance.status()).thenReturn((Object)1);
        this.instances.create(this.id, (ProcessInstance)instance);
        ArgumentCaptor kafkaCaptor = ArgumentCaptor.forClass(ProducerRecord.class);
        ((KafkaProducer)Mockito.verify((Object)this.producer)).send((ProducerRecord)kafkaCaptor.capture());
        Assertions.assertThat((Object)((ProducerRecord)kafkaCaptor.getValue()).value()).isEqualTo((Object)new byte[0]);
        Assertions.assertThat((Object)((ProducerRecord)kafkaCaptor.getValue()).key()).isEqualTo((Object)this.storedId);
        Assertions.assertThat((String)((ProducerRecord)kafkaCaptor.getValue()).topic()).isEqualTo(KafkaPersistenceUtils.topicName());
        ArgumentCaptor supplierCaptor = ArgumentCaptor.forClass(Consumer.class);
        ((ReadOnlyKeyValueStore)Mockito.verify(this.store)).get((Object)this.storedId);
    }

    @Test
    public void testProcessInstancesCreateNotActive() {
        AbstractProcessInstance instance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        Mockito.when((Object)instance.status()).thenReturn((Object)2);
        this.instances.create(this.id, (ProcessInstance)instance);
        ((KafkaProducer)Mockito.verify((Object)this.producer, (VerificationMode)Mockito.never())).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
    }

    @Test
    public void testProcessInstancesCreateException() {
        ((KafkaProducer)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.producer)).send((ProducerRecord)ArgumentMatchers.any());
        AbstractProcessInstance instance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        ((ProcessInstanceMarshallerService)Mockito.doReturn((Object)new byte[0]).when((Object)this.marshaller)).marshallProcessInstance((ProcessInstance)instance);
        Mockito.when((Object)instance.status()).thenReturn((Object)1);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.instances.create(this.id, (ProcessInstance)instance));
    }

    @Test
    public void testProcessInstancesCreateDuplicate() {
        Mockito.when((Object)((byte[])this.store.get((Object)this.storedId))).thenReturn((Object)new byte[0]);
        AbstractProcessInstance instance = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        Mockito.when((Object)instance.status()).thenReturn((Object)1);
        Assertions.assertThatExceptionOfType(ProcessInstanceDuplicatedException.class).isThrownBy(() -> this.instances.create(this.id, (ProcessInstance)instance));
    }
}

