/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.kafka;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Materialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersistenceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPersistenceUtils.class);
    private static final String TOPIC = "kogito.process";
    private static final String STORE = "kogito-store";

    private KafkaPersistenceUtils() {
    }

    public static String topicName() {
        return TOPIC;
    }

    public static String storeName() {
        return STORE;
    }

    public static Topology createTopologyForProcesses() {
        StreamsBuilder builder = new StreamsBuilder();
        builder.globalTable(KafkaPersistenceUtils.topicName(), Materialized.as((String)KafkaPersistenceUtils.storeName()).withKeySerde(Serdes.String()).withValueSerde(Serdes.ByteArray()));
        LOGGER.info("Created Kafka Stream GlobalTable");
        return builder.build();
    }
}

