/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.kafka;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.drools.io.ClassPathResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KafkaProcessInstancesFactory;
import org.kie.kogito.persistence.kafka.KafkaPersistenceUtils;
import org.kie.kogito.persistence.kafka.KafkaStreamsStateListener;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.test.utils.ProcessInstancesTestUtils;
import org.kie.kogito.testcontainers.KogitoKafkaContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class KafkaProcessInstancesIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaProcessInstancesIT.class);
    private static final Duration TIMEOUT = Duration.ofMinutes(1L);
    @Container
    KogitoKafkaContainer kafka = new KogitoKafkaContainer();
    KafkaProcessInstancesFactory factory;
    KafkaStreamsStateListener listener;

    @BeforeEach
    void start() {
        this.listener = new KafkaStreamsStateListener();
        this.factory = new KafkaProcessInstancesFactory();
        this.factory.setKafkaConfig(Collections.singletonMap("bootstrap.servers", this.kafka.getBootstrapServers()));
        this.factory.setStateListener(this.listener);
    }

    @AfterEach
    void stop() {
        if (this.factory != null) {
            this.factory.stop();
        }
        if (this.listener.getKafkaStreams() != null) {
            this.listener.getKafkaStreams().close();
            this.listener.getKafkaStreams().cleanUp();
        }
        this.listener.close();
    }

    private <T> void awaitTillOne(ProcessInstances<T> instances) {
        this.awaitTillSize(instances, 1);
    }

    private <T> void awaitTillEmpty(ProcessInstances<T> instances) {
        this.awaitTillSize(instances, 0);
    }

    private <T> void awaitTillSize(ProcessInstances<T> instances, int size) {
        Awaitility.await().atMost(TIMEOUT).until(() -> {
            try (Stream stream = instances.stream();){
                Boolean bl = stream.count() == (long)size;
                return bl;
            }
        });
    }

    @Test
    void testFindByIdReadMode() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask-Script.bpmn2")}).get(0);
        this.listener.setKafkaStreams(this.createStreams());
        process.setProcessInstancesFactory((ProcessInstancesFactory)this.factory);
        process.configure();
        this.listener.getKafkaStreams().start();
        ProcessInstances instances = process.instances();
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)instances);
        ProcessInstance mutablePi = process.createInstance(BpmnVariables.create(Collections.singletonMap("var", "value")));
        mutablePi.start();
        Assertions.assertThat((int)mutablePi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)mutablePi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException"});
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)mutablePi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        ProcessInstance pi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ProcessInstance readOnlyPi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThat((int)readOnlyPi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)readOnlyPi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException"});
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)readOnlyPi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> readOnlyPi.abort());
        ((ProcessInstance)instances.findById(mutablePi.id()).get()).abort();
        this.awaitTillEmpty(instances);
    }

    @Test
    void testValuesReadMode() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        this.listener.setKafkaStreams(this.createStreams());
        process.setProcessInstancesFactory((ProcessInstancesFactory)this.factory);
        process.configure();
        this.listener.getKafkaStreams().start();
        ProcessInstances instances = process.instances();
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)instances);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        this.awaitTillOne(instances);
        ProcessInstance pi = ProcessInstancesTestUtils.getFirst((ProcessInstances)instances);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ProcessInstancesTestUtils.abortFirst((ProcessInstances)instances);
        this.awaitTillEmpty(instances);
    }

    @Test
    void testBasicFlow() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        this.listener.setKafkaStreams(this.createStreams());
        process.setProcessInstancesFactory((ProcessInstancesFactory)this.factory);
        process.configure();
        this.listener.getKafkaStreams().start();
        ProcessInstances instances = process.instances();
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)instances);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        this.awaitTillOne(instances);
        SecurityPolicy asJohn = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john"));
        Assertions.assertThat((List)ProcessInstancesTestUtils.getFirst((ProcessInstances)instances).workItems(new Policy[]{asJohn})).hasSize(1);
        List workItems = processInstance.workItems(new Policy[]{asJohn});
        Assertions.assertThat((List)workItems).hasSize(1);
        WorkItem workItem = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", workItem.getParameters().get("ActorId"));
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{asJohn});
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
        this.awaitTillEmpty(instances);
    }

    KafkaStreams createStreams() {
        Topology topology = KafkaPersistenceUtils.createTopologyForProcesses();
        KafkaStreams streams = new KafkaStreams(topology, this.getStreamsConfig());
        streams.setUncaughtExceptionHandler(throwable -> {
            LOGGER.error("Kafka persistence error: " + throwable.getMessage(), throwable);
            return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.REPLACE_THREAD;
        });
        streams.cleanUp();
        return streams;
    }

    Properties getStreamsConfig() {
        Properties properties = new Properties();
        properties.put("application.id", "kogito");
        properties.put("bootstrap.servers", this.kafka.getBootstrapServers());
        return properties;
    }
}

