/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.quarkus.rocksdb;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.kie.kogito.persistence.quarkus.rocksdb.RocksDbConfig;
import org.kie.kogito.persistence.rocksdb.RocksDBProcessInstancesFactory;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RocksDbProcessInstancesFactoryProducer {
    private static final Logger logger = LoggerFactory.getLogger(RocksDbProcessInstancesFactoryProducer.class);
    private Options options;
    private RocksDBProcessInstancesFactory processInstancesFactory;
    @Inject
    RocksDbConfig config;

    @PostConstruct
    void init() throws RocksDBException {
        this.options = new Options();
        this.options.setCreateIfMissing(true);
        String dataDir = this.config.dataDir();
        logger.info("Opening rocksdb in directory {}", (Object)dataDir);
        this.processInstancesFactory = new RocksDBProcessInstancesFactory(this.options, dataDir);
    }

    @Produces
    ProcessInstancesFactory factory() {
        return this.processInstancesFactory;
    }

    @PreDestroy
    void cleanup() throws RocksDBException {
        this.processInstancesFactory.close();
        if (this.config.destroyDB()) {
            String dataDir = this.config.dataDir();
            logger.info("Cleaning rocksdb in directory {}", (Object)dataDir);
            RocksDB.destroyDB((String)dataDir, (Options)this.options);
        }
        this.options.close();
    }
}

