/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.rest;

import java.io.IOException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.svg.ProcessSvgService;
import org.kie.kogito.svg.rest.ProcessSvgResource;
import org.kie.kogito.svg.service.QuarkusProcessSvgService;
import org.mockito.Mockito;

class ProcessSvgResourceTest {
    private static final String PROCESS_INSTANCE_ID = "piId";
    private static final String PROCESS_ID = "travels";
    private ProcessSvgResource processSvgResourceTest;
    private QuarkusProcessSvgService processSvgServiceMock;

    ProcessSvgResourceTest() {
    }

    @BeforeEach
    public void setup() {
        this.processSvgResourceTest = new ProcessSvgResource();
        this.processSvgServiceMock = (QuarkusProcessSvgService)Mockito.mock(QuarkusProcessSvgService.class);
        this.processSvgResourceTest.setProcessSvgService((ProcessSvgService)this.processSvgServiceMock);
    }

    @Test
    void getProcessSvgTest() {
        this.processSvgResourceTest.getProcessSvg(PROCESS_ID);
        ((QuarkusProcessSvgService)Mockito.verify((Object)this.processSvgServiceMock)).getProcessSvg(PROCESS_ID);
    }

    @Test
    void getExecutionPathByProcessInstanceIdTest() throws IOException {
        String authHeader = "Bearer: token";
        this.processSvgResourceTest.getExecutionPathByProcessInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, authHeader);
        ((QuarkusProcessSvgService)Mockito.verify((Object)this.processSvgServiceMock)).getProcessInstanceSvg(PROCESS_ID, PROCESS_INSTANCE_ID, authHeader);
    }
}

