/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.dataindex;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.dataindex.DataIndexClient;
import org.kie.kogito.svg.dataindex.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class QuarkusDataIndexClient
implements DataIndexClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuarkusDataIndexClient.class);
    private Vertx vertx;
    private WebClient client;
    private String dataIndexHttpURL;

    @Inject
    public QuarkusDataIndexClient(@ConfigProperty(name="kogito.dataindex.http.url", defaultValue="http://localhost:8180") String dataIndexHttpURL, Vertx vertx) {
        this.dataIndexHttpURL = dataIndexHttpURL;
        this.vertx = vertx;
    }

    @PostConstruct
    protected void setup() throws MalformedURLException {
        this.client = WebClient.create((Vertx)this.vertx, (WebClientOptions)this.getWebClientToURLOptions(this.dataIndexHttpURL));
        LOGGER.debug("Creating new instance of web client");
    }

    protected WebClientOptions getWebClientToURLOptions(String targetHttpURL) throws MalformedURLException {
        URL dataIndexURL = new URL(targetHttpURL);
        return new WebClientOptions().setDefaultHost(dataIndexURL.getHost()).setDefaultPort(dataIndexURL.getPort() != -1 ? dataIndexURL.getPort() : dataIndexURL.getDefaultPort()).setSsl(dataIndexURL.getProtocol().compareToIgnoreCase("https") == 0);
    }

    public List<NodeInstance> getNodeInstancesFromProcessInstance(String processInstanceId, String authHeader) {
        String query = this.getNodeInstancesQuery(processInstanceId);
        Future future = this.client.post("/graphql").putHeader("Authorization", authHeader).putHeader("content-type", "application/json").sendJson((Object)JsonObject.mapFrom(Collections.singletonMap("query", query))).map(response -> {
            if (response.statusCode() == 200) {
                return this.getNodeInstancesFromResponse(response.bodyAsJsonObject());
            }
            return null;
        });
        try {
            return (List)future.toCompletionStage().toCompletableFuture().get();
        }
        catch (Exception e) {
            throw new ProcessSVGException("Exception while trying to get data from Data Index service", (Throwable)e);
        }
    }

    protected List<NodeInstance> getNodeInstancesFromResponse(JsonObject response) {
        JsonArray pInstancesArray = response.getJsonObject("data").getJsonArray("ProcessInstances");
        if (pInstancesArray != null && !pInstancesArray.isEmpty()) {
            ArrayList<NodeInstance> nodes = new ArrayList<NodeInstance>();
            JsonArray nodesArray = pInstancesArray.getJsonObject(0).getJsonArray("nodes");
            nodesArray.forEach(node -> {
                JsonObject json = (JsonObject)node;
                nodes.add(new NodeInstance(Boolean.valueOf(Objects.nonNull(json.getString("exit"))), json.getString("definitionId")));
            });
            return nodes;
        }
        return Collections.emptyList();
    }
}

