/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.dataindex;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClientOptions;
import java.net.MalformedURLException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.svg.dataindex.NodeInstance;
import org.kie.kogito.svg.dataindex.QuarkusDataIndexClient;

public class QuarkusDataIndexClientTest {
    private static final String jsonString = "{\n  \"data\": {\n    \"ProcessInstances\": [\n      {\n        \"id\": \"piId\",\n        \"processId\": \"processId\",\n        \"nodes\": [\n          {\n            \"definitionId\": \"_9861B686-DF6B-4B1C-B370-F9898EEB47FD\",\n            \"exit\": \"2020-10-11T06:49:47.26Z\"\n          },\n          {\n            \"definitionId\": \"_8B62D3CA-5D03-4B2B-832B-126469288BB4\",\n            \"exit\": null\n          }\n        ]\n      }     ]\n  }\n}";
    QuarkusDataIndexClient client = new QuarkusDataIndexClient(null, null);

    @Test
    public void testGetNodeInstancesFromResponse() {
        JsonObject response = (JsonObject)Json.decodeValue((String)jsonString);
        List nodes = this.client.getNodeInstancesFromResponse(response);
        ((ListAssert)Assertions.assertThat((List)nodes).hasSize(2)).containsExactly((Object[])new NodeInstance[]{new NodeInstance(Boolean.valueOf(true), "_9861B686-DF6B-4B1C-B370-F9898EEB47FD"), new NodeInstance(Boolean.valueOf(false), "_8B62D3CA-5D03-4B2B-832B-126469288BB4")});
    }

    @Test
    public void testGetEmptyNodeInstancesFromResponse() {
        JsonObject response = new JsonObject().put("data", (Object)new JsonObject().put("ProcessInstances", (Object)new JsonArray()));
        List nodes = this.client.getNodeInstancesFromResponse(response);
        Assertions.assertThat((List)nodes).isEmpty();
    }

    @Test
    public void testWebClientToURLOptionsMalformedURL() {
        org.junit.jupiter.api.Assertions.assertThrows(MalformedURLException.class, () -> this.client.getWebClientToURLOptions("malformedURL"));
    }

    @Test
    public void testSetupMalformedURL() {
        QuarkusDataIndexClient testClient = new QuarkusDataIndexClient("malformedURL", null);
        org.junit.jupiter.api.Assertions.assertThrows(MalformedURLException.class, () -> testClient.setup());
    }

    @Test
    public void testWebClientToURLOptions() throws MalformedURLException {
        String defaultHost = "localhost";
        int defaultPort = 8180;
        WebClientOptions webClientOptions = this.client.getWebClientToURLOptions("http://" + defaultHost + ":" + defaultPort);
        Assertions.assertThat((String)webClientOptions.getDefaultHost()).isEqualTo(defaultHost);
        Assertions.assertThat((int)webClientOptions.getDefaultPort()).isEqualTo(defaultPort);
    }

    @Test
    public void testWebClientToURLOptionsWithoutPort() throws MalformedURLException {
        String dataindexurl = "http://dataIndex.com";
        WebClientOptions webClientOptions = this.client.getWebClientToURLOptions(dataindexurl);
        Assertions.assertThat((int)webClientOptions.getDefaultPort()).isEqualTo(80);
        Assertions.assertThat((String)webClientOptions.getDefaultHost()).isEqualTo("dataIndex.com");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)webClientOptions.isSsl());
    }

    @Test
    public void testWebClientToURLOptionsWithoutPortSSL() throws MalformedURLException {
        String dataindexurl = "https://dataIndex.com";
        WebClientOptions webClientOptions = this.client.getWebClientToURLOptions(dataindexurl);
        Assertions.assertThat((int)webClientOptions.getDefaultPort()).isEqualTo(443);
        Assertions.assertThat((String)webClientOptions.getDefaultHost()).isEqualTo("dataIndex.com");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)webClientOptions.isSsl());
    }
}

