/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.quarkus.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.ws.rs.core.Response;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.Application;
import org.kie.kogito.jobs.quarkus.common.CallbackJobsServiceResource;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.Signal;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CallbackJobsServiceResourceTest {
    private static final String PROCESS_ID = "PROCESS_ID";
    private static final String PROCESS_INSTANCE_ID = "PROCESS_INSTANCE_ID";
    private static final String JOB_ID = "JOB_ID";
    private static final String TIMER_ID = "TIMER_ID";
    private static final int LIMIT = 1;
    private static final String PAYLOAD = "{\"correlationId\":\"JOB_ID\"}";
    @Mock
    private Processes processes;
    @Mock
    private Application application;
    @Mock
    private UnitOfWorkManager unitOfWorkManager;
    @Mock
    private UnitOfWork unitOfWork;
    @Mock
    private Process<?> process;
    @Mock
    private ProcessInstances<?> instances;
    @Mock
    private ProcessInstance<?> processInstance;
    private CallbackJobsServiceResource resource;

    CallbackJobsServiceResourceTest() {
    }

    @BeforeEach
    void setUp() {
        this.resource = new CallbackJobsServiceResource();
        this.resource.application = (Instance)Mockito.mock(Instance.class);
        this.resource.processes = (Instance)Mockito.mock(Instance.class);
        this.resource.objectMapper = new ObjectMapper();
        Mockito.lenient().when((Object)((Application)this.resource.application.get())).thenReturn((Object)this.application);
        Mockito.lenient().when((Object)((Processes)this.resource.processes.get())).thenReturn((Object)this.processes);
    }

    @Test
    void triggerTimerProcessIdNotPresent() {
        this.triggerTimerProcessIdOrProcessInstanceIdNotPresent(null, PROCESS_INSTANCE_ID);
    }

    @Test
    void triggerTimerProcessInstanceIdNotPresent() {
        this.triggerTimerProcessIdOrProcessInstanceIdNotPresent(PROCESS_ID, null);
    }

    private void triggerTimerProcessIdOrProcessInstanceIdNotPresent(String processId, String processInstanceId) {
        Response response = this.resource.triggerTimer(processId, processInstanceId, TIMER_ID, Integer.valueOf(1), PAYLOAD);
        AssertionsForInterfaceTypes.assertThat((int)response.getStatus()).isEqualTo(Response.Status.BAD_REQUEST.getStatusCode());
        AssertionsForInterfaceTypes.assertThat((Object)response.getEntity()).isEqualTo((Object)"Process id and Process instance id must be given");
    }

    @Test
    void triggerTimerProcessNotFound() {
        Response response = this.resource.triggerTimer(PROCESS_ID, PROCESS_INSTANCE_ID, TIMER_ID, Integer.valueOf(1), PAYLOAD);
        AssertionsForInterfaceTypes.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
        AssertionsForInterfaceTypes.assertThat((Object)response.getEntity()).isEqualTo((Object)"Process with id PROCESS_ID not found");
    }

    @Test
    void triggerTimerProcessInstanceNotFound() {
        ((Processes)Mockito.doReturn(this.process).when((Object)this.processes)).processById(PROCESS_ID);
        ((Process)Mockito.doReturn(this.instances).when(this.process)).instances();
        ((Application)Mockito.doReturn((Object)this.unitOfWorkManager).when((Object)this.application)).unitOfWorkManager();
        ((UnitOfWorkManager)Mockito.doReturn((Object)this.unitOfWork).when((Object)this.unitOfWorkManager)).newUnitOfWork();
        ((ProcessInstances)Mockito.doReturn(Optional.empty()).when(this.instances)).findById(PROCESS_INSTANCE_ID);
        Response response = this.resource.triggerTimer(PROCESS_ID, PROCESS_INSTANCE_ID, TIMER_ID, Integer.valueOf(1), PAYLOAD);
        AssertionsForInterfaceTypes.assertThat((int)response.getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
        AssertionsForInterfaceTypes.assertThat((Object)response.getEntity()).isEqualTo((Object)"Process instance with id PROCESS_INSTANCE_ID not found");
    }

    @Test
    void triggerTimerOK() {
        ((Processes)Mockito.doReturn(this.process).when((Object)this.processes)).processById(PROCESS_ID);
        ((Process)Mockito.doReturn(this.instances).when(this.process)).instances();
        ((Application)Mockito.doReturn((Object)this.unitOfWorkManager).when((Object)this.application)).unitOfWorkManager();
        ((UnitOfWorkManager)Mockito.doReturn((Object)this.unitOfWork).when((Object)this.unitOfWorkManager)).newUnitOfWork();
        ((ProcessInstances)Mockito.doReturn(Optional.of(this.processInstance)).when(this.instances)).findById(PROCESS_INSTANCE_ID);
        Response response = this.resource.triggerTimer(PROCESS_ID, PROCESS_INSTANCE_ID, TIMER_ID, Integer.valueOf(1), PAYLOAD);
        AssertionsForInterfaceTypes.assertThat((int)response.getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
        ((ProcessInstance)Mockito.verify(this.processInstance)).send((Signal)ArgumentMatchers.any());
    }
}

