/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resource.exceptions;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.resource.exceptions.ExceptionsHandler;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ExceptionsHandlerTest {
    private ExceptionsHandler tested;
    @Mock
    private Object body;
    @Mock
    private RuntimeDelegate runtimeDelegate;
    @Mock
    private Response.ResponseBuilder builder;
    @Mock
    private Response response;

    ExceptionsHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.tested = new ExceptionsHandler();
        RuntimeDelegate.setInstance((RuntimeDelegate)this.runtimeDelegate);
        Mockito.when((Object)this.runtimeDelegate.createResponseBuilder()).thenReturn((Object)this.builder);
        Mockito.when((Object)this.builder.status((Response.StatusType)ArgumentMatchers.any(Response.StatusType.class))).thenReturn((Object)this.builder);
        Mockito.when((Object)this.builder.header(ArgumentMatchers.anyString(), ArgumentMatchers.any())).thenReturn((Object)this.builder);
        Mockito.when((Object)this.builder.entity(ArgumentMatchers.any())).thenReturn((Object)this.builder);
        Mockito.when((Object)this.builder.build()).thenReturn((Object)this.response);
    }

    @Test
    void testBadRequest() {
        this.tested.badRequest(this.body);
        this.assertRequest(Response.Status.BAD_REQUEST);
    }

    private void assertRequest(Response.Status status) {
        ((Response.ResponseBuilder)Mockito.verify((Object)this.builder)).header("Content-Type", (Object)"application/json");
        ((Response.ResponseBuilder)Mockito.verify((Object)this.builder)).status((Response.StatusType)status);
        ((Response.ResponseBuilder)Mockito.verify((Object)this.builder)).entity(this.body);
    }

    @Test
    void testConflict() {
        this.tested.conflict(this.body);
        this.assertRequest(Response.Status.CONFLICT);
    }

    @Test
    void testInternalError() {
        this.tested.internalError(this.body);
        this.assertRequest(Response.Status.INTERNAL_SERVER_ERROR);
    }

    @Test
    void testNotFound() {
        this.tested.notFound(this.body);
        this.assertRequest(Response.Status.NOT_FOUND);
    }

    @Test
    void testForbidden() {
        this.tested.forbidden(this.body);
        this.assertRequest(Response.Status.FORBIDDEN);
    }
}

