/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import org.kie.kogito.addon.source.files.SourceFilesProviderProducer;
import org.kie.kogito.addon.source.files.SourceFilesRecorder;
import org.kie.kogito.addon.source.files.deployment.SourceFileProcessBindListenerImpl;
import org.kie.kogito.addon.source.files.deployment.SourceFileServerlessWorkflowBindListenerImpl;
import org.kie.kogito.codegen.api.SourceFileCodegenBindListener;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.io.CollectedResource;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;
import org.kie.kogito.quarkus.addons.common.deployment.RequireCapabilityKogitoAddOnProcessor;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;

class KogitoAddOnSourceFilesProcessor
extends RequireCapabilityKogitoAddOnProcessor {
    private static final String FEATURE = "kogito-addon-source-files-extension";
    private static final Collection<String> SOURCE_FILE_EXTENSIONS = List.of(".bpmn", ".bpmn2", ".json", ".yaml", ".yml");

    KogitoAddOnSourceFilesProcessor() {
        super(new KogitoCapability[]{KogitoCapability.PROCESSES});
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem sourceFilesProviderProducer() {
        return new AdditionalBeanBuildItem(new Class[]{SourceFilesProviderProducer.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void addSourceFileProcessBindListener(KogitoBuildContextBuildItem ctxBuildItem, SourceFilesRecorder sourceFilesRecorder) {
        KogitoBuildContext kogitoBuildContext = ctxBuildItem.getKogitoBuildContext();
        SourceFileProcessBindListenerImpl processListener = new SourceFileProcessBindListenerImpl(kogitoBuildContext.getAppPaths().getResourceFiles(), sourceFilesRecorder);
        SourceFileServerlessWorkflowBindListenerImpl serverlessWorkflowListener = new SourceFileServerlessWorkflowBindListenerImpl(kogitoBuildContext.getAppPaths().getResourceFiles(), sourceFilesRecorder);
        kogitoBuildContext.getSourceFileCodegenBindNotifier().ifPresent(notifier -> notifier.addListeners(new SourceFileCodegenBindListener[]{processListener, serverlessWorkflowListener}));
    }

    @BuildStep
    void produceSourceFiles(KogitoBuildContextBuildItem ctxBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<AdditionalStaticResourceBuildItem> additionalStaticResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer) {
        Path sourcesDestinationPath = ctxBuildItem.getKogitoBuildContext().getAppPaths().getOutputTarget().resolve(Path.of("classes/META-INF/resources/sources/", new String[0]));
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])ctxBuildItem.getKogitoBuildContext().getAppPaths().getPaths());
        collectedResources.stream().filter(this::isSourceFile).forEach(resource -> KogitoAddOnSourceFilesProcessor.generateStaticResource(sourcesDestinationPath, generatedResourceProducer, additionalStaticResourceProducer, nativeImageResourceProducer, resource));
    }

    private static void generateStaticResource(Path sourcesDestinationPath, BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<AdditionalStaticResourceBuildItem> additionalStaticResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, CollectedResource resource) {
        byte[] contents;
        Path sourceFile = Paths.get(resource.resource().getSourcePath(), new String[0]);
        Path relativeDestinationFilePath = sourceFile.startsWith(resource.basePath()) ? sourceFile.subpath(resource.basePath().getNameCount(), sourceFile.getNameCount()) : sourceFile;
        try {
            contents = resource.resource().getInputStream().readAllBytes();
            Path absoluteDestinationFilePath = sourcesDestinationPath.resolve(relativeDestinationFilePath);
            KogitoAddOnSourceFilesProcessor.createDirectories(absoluteDestinationFilePath.getParent());
            Files.write(absoluteDestinationFilePath, contents, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to move source file to static resources directory.", e);
        }
        String sourcesDestinationDirectory = "META-INF/resources/sources/";
        generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(sourcesDestinationDirectory + relativeDestinationFilePath, contents, true));
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{sourcesDestinationDirectory + relativeDestinationFilePath}));
        additionalStaticResourceProducer.produce((BuildItem)new AdditionalStaticResourceBuildItem("/sources/" + relativeDestinationFilePath, false));
    }

    private static void createDirectories(Path path) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            KogitoAddOnSourceFilesProcessor.createDirectories(path.getParent());
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    private boolean isSourceFile(CollectedResource resource) {
        return SOURCE_FILE_EXTENSIONS.stream().anyMatch(ext -> resource.resource().getSourcePath().endsWith((String)ext));
    }
}

