/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import org.kie.kogito.addon.source.files.SourceFilesProviderProducer;
import org.kie.kogito.addon.source.files.SourceFilesRecorder;
import org.kie.kogito.addon.source.files.deployment.SourceFileProcessBindListenerImpl;
import org.kie.kogito.addon.source.files.deployment.SourceFileServerlessWorkflowBindListenerImpl;
import org.kie.kogito.codegen.api.SourceFileCodegenBindListener;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;
import org.kie.kogito.quarkus.addons.common.deployment.RequireCapabilityKogitoAddOnProcessor;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;

class KogitoAddOnSourceFilesProcessor
extends RequireCapabilityKogitoAddOnProcessor {
    private static final String FEATURE = "kogito-addon-source-files-extension";

    KogitoAddOnSourceFilesProcessor() {
        super(new KogitoCapability[]{KogitoCapability.PROCESSES});
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem sourceFilesProviderProducer() {
        return new AdditionalBeanBuildItem(new Class[]{SourceFilesProviderProducer.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void addSourceFileProcessBindListener(KogitoBuildContextBuildItem ctxBuildItem, SourceFilesRecorder sourceFilesRecorder) {
        KogitoBuildContext kogitoBuildContext = ctxBuildItem.getKogitoBuildContext();
        SourceFileProcessBindListenerImpl processListener = new SourceFileProcessBindListenerImpl(kogitoBuildContext.getAppPaths().getResourceFiles(), sourceFilesRecorder);
        SourceFileServerlessWorkflowBindListenerImpl serverlessWorkflowListener = new SourceFileServerlessWorkflowBindListenerImpl(kogitoBuildContext.getAppPaths().getResourceFiles(), sourceFilesRecorder);
        kogitoBuildContext.getSourceFileCodegenBindNotifier().ifPresent(notifier -> notifier.addListeners(new SourceFileCodegenBindListener[]{processListener, serverlessWorkflowListener}));
    }
}

