/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import io.quarkus.security.UnauthorizedException;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.security.TestSecurity;
import java.util.Collection;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesProviderImpl;
import org.kie.kogito.addon.source.files.SourceFilesResource;

@QuarkusTest
class SourceFilesResourceTest {
    @Inject
    SourceFilesResource sourceFilesResource;
    @Inject
    SourceFilesProviderImpl sourceFilesProvider;

    SourceFilesResourceTest() {
    }

    @BeforeEach
    void clearSourceFilesProvider() {
        this.sourceFilesProvider.clear();
    }

    @Test
    @TestSecurity(user="scott", roles={"source-files-client"})
    void getSourceFilesByProcessId() {
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("petstore.json"));
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("petstore.sw.json"));
        Collection sourceFiles = this.sourceFilesResource.getSourceFiles("a_process");
        Assertions.assertThat((Collection)sourceFiles).containsExactlyInAnyOrder((Object[])new SourceFile[]{new SourceFile("petstore.json"), new SourceFile("petstore.sw.json")});
    }

    @Test
    void getSourceFilesByProcessIdNonAuthenticated() {
        Assertions.assertThatCode(() -> this.sourceFilesResource.getSourceFiles("a_process")).isInstanceOf(UnauthorizedException.class);
    }
}

