/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import java.util.Collection;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesProvider;

@ApplicationScoped
@Path(value="/management/processes/")
public final class SourceFilesResource {
    SourceFilesProvider sourceFilesProvider;

    @GET
    @Path(value="{processId}/sources")
    @Produces(value={"application/json"})
    public Collection<SourceFile> getSourceFilesByProcessId(@PathParam(value="processId") String processId) {
        return this.sourceFilesProvider.getProcessSourceFiles(processId);
    }

    @GET
    @Path(value="{processId}/source")
    @Produces(value={"text/plain"})
    public Response getSourceFileByProcessId(@PathParam(value="processId") String processId) {
        Optional processSourceFileContent = this.sourceFilesProvider.getProcessSourceFile(processId);
        if (processSourceFileContent.isPresent()) {
            return Response.ok(processSourceFileContent.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Inject
    void setSourceFilesProvider(SourceFilesProvider sourceFilesProvider) {
        this.sourceFilesProvider = sourceFilesProvider;
    }
}

