/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesProvider;
import org.kie.kogito.resource.exceptions.ExceptionsHandler;

@ApplicationScoped
@Path(value="/management/processes/")
public final class SourceFilesResource {
    private static final ExceptionsHandler EXCEPTIONS_HANDLER = new ExceptionsHandler();
    SourceFilesProvider sourceFilesProvider;

    @GET
    @Path(value="sources")
    @Produces(value={"application/octet-stream"})
    public Response getSourceFileByUri(@QueryParam(value="uri") String uri) {
        return this.sourceFilesProvider.getSourceFilesByUri(uri).map(sourceFile -> {
            Response response;
            ByteArrayInputStream file = new ByteArrayInputStream(sourceFile.readContents());
            try {
                response = Response.ok((Object)file, (String)"application/octet-stream").header("Content-Disposition", (Object)("inline; filename=\"" + java.nio.file.Path.of(sourceFile.getUri(), new String[0]).getFileName() + "\"")).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)file).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return (Response)EXCEPTIONS_HANDLER.mapException(e);
                }
            }
            ((InputStream)file).close();
            return response;
        }).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @GET
    @Path(value="{processId}/sources")
    @Produces(value={"application/json"})
    public Collection<SourceFile> getSourceFilesByProcessId(@PathParam(value="processId") String processId) {
        return this.sourceFilesProvider.getProcessSourceFiles(processId);
    }

    @GET
    @Path(value="{processId}/source")
    @Produces(value={"text/plain"})
    public Response getSourceFileByProcessId(@PathParam(value="processId") String processId) {
        return this.sourceFilesProvider.getProcessSourceFile(processId).map(sourceFile -> {
            try {
                return Response.ok((Object)sourceFile.readContents()).build();
            }
            catch (IOException e) {
                return (Response)EXCEPTIONS_HANDLER.mapException((Exception)e);
            }
        }).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @Inject
    void setSourceFilesProvider(SourceFilesProvider sourceFilesProvider) {
        this.sourceFilesProvider = sourceFilesProvider;
    }
}

