/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesProvider;
import org.kie.kogito.addon.source.files.SourceFilesResource;
import org.mockito.Mock;
import org.mockito.Mockito;

@QuarkusTest
class SourceFilesResourceTest {
    private static final String PROCESS_ID = "processId";
    private SourceFilesResource sourceFilesTestResource;
    @Mock
    private SourceFilesProvider mockSourceFileProvider;

    SourceFilesResourceTest() {
    }

    @BeforeEach
    void setup() {
        this.sourceFilesTestResource = new SourceFilesResource();
        this.mockSourceFileProvider = (SourceFilesProvider)Mockito.mock(SourceFilesProvider.class);
        this.sourceFilesTestResource.setSourceFilesProvider(this.mockSourceFileProvider);
    }

    @Test
    void getSourceFilesByProcessIdTest() {
        this.sourceFilesTestResource.getSourceFilesByProcessId(PROCESS_ID);
        ((SourceFilesProvider)Mockito.verify((Object)this.mockSourceFileProvider)).getProcessSourceFiles(PROCESS_ID);
    }

    @Test
    void getEmptySourceFileByProcessIdTest() {
        Mockito.when((Object)this.mockSourceFileProvider.getProcessSourceFile(PROCESS_ID)).thenReturn(Optional.empty());
        Assertions.assertThat((int)this.sourceFilesTestResource.getSourceFileByProcessId(PROCESS_ID).getStatus()).isEqualTo(Response.Status.NOT_FOUND.getStatusCode());
        ((SourceFilesProvider)Mockito.verify((Object)this.mockSourceFileProvider)).getProcessSourceFile(PROCESS_ID);
    }

    @Test
    void getValidSourceFileByProcessIdTest() {
        Mockito.when((Object)this.mockSourceFileProvider.getProcessSourceFile(PROCESS_ID)).thenReturn(Optional.of(new SourceFile("petstore.sw.json")));
        Assertions.assertThat((int)this.sourceFilesTestResource.getSourceFileByProcessId(PROCESS_ID).getStatus()).isEqualTo(Response.Status.OK.getStatusCode());
        ((SourceFilesProvider)Mockito.verify((Object)this.mockSourceFileProvider)).getProcessSourceFile(PROCESS_ID);
    }
}

