/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class QuarkusTracingAddonDevServicesIT {
    private static final String KOGITO_EXECUTION_ID_HEADER = "X-Kogito-execution-id";
    @RegisterExtension
    public static QuarkusDevModeTest test = new QuarkusDevModeTest().withApplicationRoot(jar -> {
        jar.addAsResource((Asset)new StringAsset(QuarkusTracingAddonDevServicesIT.loadResource("/application.properties")), "application.properties");
        jar.addAsResource((Asset)new StringAsset(QuarkusTracingAddonDevServicesIT.loadResource("/LoanEligibility.dmn")), "LoanEligibility.dmn");
    });

    @Test
    public void testEvaluateLoanEligibility() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)this.execute().then()).statusCode(200)).header(KOGITO_EXECUTION_ID_HEADER, Matchers.notNullValue())).body("'Decide'", Matchers.is((Object)true), new Object[0]);
    }

    @Test
    public void testExecutionsAreStored() {
        ArrayList<String> executionIds = new ArrayList<String>();
        executionIds.add(this.executeAndGetExecutionId());
        executionIds.add(this.executeAndGetExecutionId());
        executionIds.add(this.executeAndGetExecutionId());
        String trustyServiceEndpoint = System.getProperty("kogito.trusty.http.url");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).until(() -> {
            Response response = (Response)RestAssured.given().when().get(trustyServiceEndpoint + "/executions", new Object[0]);
            String json = response.prettyPrint();
            return executionIds.stream().allMatch(executionId -> json.contains("\"executionId\": \"" + executionId + "\""));
        });
    }

    private Response execute() {
        return (Response)RestAssured.given().body("{    \"Client\": {        \"age\": 43,        \"salary\": 1950,        \"existing payments\": 100    },    \"Loan\": {        \"duration\": 15,        \"installment\": 180    },    \"SupremeDirector\" : \"Yes\",    \"Bribe\": 1000}").contentType(ContentType.JSON).when().post("/LoanEligibility", new Object[0]);
    }

    private String executeAndGetExecutionId() {
        Headers headers = this.execute().headers();
        Assertions.assertTrue((boolean)headers.hasHeaderWithName(KOGITO_EXECUTION_ID_HEADER));
        return headers.getValue(KOGITO_EXECUTION_ID_HEADER);
    }

    private static String loadResource(String name) {
        String resource = null;
        try {
            URL url = QuarkusTracingAddonDevServicesIT.class.getResource(name);
            if (Objects.nonNull(url)) {
                resource = Files.readString(Paths.get(url.toURI()), StandardCharsets.UTF_8);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException(String.format("Unable to load '%s'", name));
        }
        return resource;
    }
}

