/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesProviderImpl;

class SourceFilesProviderImplTest {
    SourceFilesProviderImplTest() {
    }

    @Test
    void addSourceFile() {
        SourceFilesProviderImpl sourceFilesProvider = new SourceFilesProviderImpl();
        sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.json"));
        Assertions.assertThat((Collection)sourceFilesProvider.getSourceFiles("a_process")).contains((Object[])new SourceFile[]{new SourceFile("myworkflow.sw.json")});
    }

    @Test
    void getSourceFilesByProcessId() {
        SourceFilesProviderImpl sourceFilesProvider = new SourceFilesProviderImpl();
        sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.json"));
        sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.yaml"));
        sourceFilesProvider.addSourceFile("another_process", new SourceFile("myanotherworkflow.sw.json"));
        sourceFilesProvider.addSourceFile("another_process", new SourceFile("myanotherworkflow.sw.yaml"));
        Assertions.assertThat((Collection)sourceFilesProvider.getSourceFiles("a_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{new SourceFile("myworkflow.sw.json"), new SourceFile("myworkflow.sw.yaml")});
        Assertions.assertThat((Collection)sourceFilesProvider.getSourceFiles("another_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{new SourceFile("myanotherworkflow.sw.json"), new SourceFile("myanotherworkflow.sw.yaml")});
    }

    @Test
    void getSourceFilesByProcessIdShouldNotReturnNull() {
        SourceFilesProviderImpl sourceFilesProvider = new SourceFilesProviderImpl();
        Assertions.assertThat((Collection)sourceFilesProvider.getSourceFiles("a_process")).isEmpty();
    }
}

