/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesException;
import org.kie.kogito.addon.source.files.SourceFilesProviderImpl;

class SourceFilesProviderImplTest {
    private SourceFilesProviderImpl sourceFilesProvider;

    SourceFilesProviderImplTest() {
    }

    private static String readFileContent(String file) throws URISyntaxException, IOException {
        Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource(file).toURI());
        return Files.readString(path);
    }

    private String getTestFileContentByFilename(String fileName) throws Exception {
        return SourceFilesProviderImplTest.readFileContent("META-INF/resources/sources/" + fileName);
    }

    @BeforeEach
    public void setup() {
        this.sourceFilesProvider = new SourceFilesProviderImpl();
    }

    @Test
    void addSourceFile() {
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.json"));
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).contains((Object[])new SourceFile[]{new SourceFile("myworkflow.sw.json")});
    }

    @Test
    void getSourceFilesByProcessId() {
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.json"));
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.yaml"));
        this.sourceFilesProvider.addSourceFile("another_process", new SourceFile("myanotherworkflow.sw.json"));
        this.sourceFilesProvider.addSourceFile("another_process", new SourceFile("myanotherworkflow.sw.yaml"));
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{new SourceFile("myworkflow.sw.json"), new SourceFile("myworkflow.sw.yaml")});
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("another_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{new SourceFile("myanotherworkflow.sw.json"), new SourceFile("myanotherworkflow.sw.yaml")});
    }

    @Test
    void getSourceFilesByProcessIdShouldNotReturnNull() {
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).isEmpty();
    }

    @Test
    void getValidSourceFileDefinitionByProcessIdTest() throws Exception {
        this.sourceFilesProvider.addSourceFile("petstore_json_process", new SourceFile("petstore.json"));
        this.sourceFilesProvider.addSourceFile("petstore_sw_json_process", new SourceFile("petstore.sw.json"));
        this.sourceFilesProvider.addSourceFile("ymlgreet.sw_process", new SourceFile("ymlgreet.sw.yml"));
        this.sourceFilesProvider.addSourceFile("bpmn_process", new SourceFile("hiring.bpmn"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("petstore_sw_json_process")).contains((Object)this.getTestFileContentByFilename("petstore.sw.json"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("ymlgreet.sw_process")).contains((Object)this.getTestFileContentByFilename("ymlgreet.sw.yml"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("bpmn_process")).contains((Object)this.getTestFileContentByFilename("hiring.bpmn"));
    }

    @Test
    void getInvalidSourceFileDefinitionByProcessIdTest() {
        this.sourceFilesProvider.addSourceFile("petstore_json_process", new SourceFile("petstore.json"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("petstore_json_process")).isEmpty();
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("invalidProcess")).isEmpty();
        this.sourceFilesProvider.addSourceFile("unexistingFile_sw_json_process", new SourceFile("unexistingFile.sw.json"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sourceFilesProvider.getProcessSourceFile("unexistingFile_sw_json_process")).isInstanceOf(SourceFilesException.class)).hasMessage("Exception trying to read definition source file with relative URI:/sources/unexistingFile.sw.json");
    }
}

