/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesException;
import org.kie.kogito.addon.source.files.SourceFilesProvider;
import org.kie.kogito.codegen.process.ProcessCodegen;

public final class SourceFilesProviderImpl
implements SourceFilesProvider {
    private final Map<String, Collection<SourceFile>> sourceFiles = new HashMap<String, Collection<SourceFile>>();

    public void addSourceFile(String id, SourceFile sourceFile) {
        this.sourceFiles.computeIfAbsent(id, k -> new HashSet()).add(sourceFile);
    }

    @Override
    public Collection<SourceFile> getProcessSourceFiles(String processId) {
        return this.sourceFiles.getOrDefault(processId, Set.of());
    }

    @Override
    public Optional<String> getProcessSourceFile(String processId) throws SourceFilesException {
        return this.getProcessSourceFiles(processId).stream().map(SourceFile::getUri).filter(this::isValidDefinitionSource).findFirst().flatMap(this::readFileContentFromClassPath);
    }

    private boolean isValidDefinitionSource(String uri) {
        if (ProcessCodegen.SUPPORTED_BPMN_EXTENSIONS.stream().noneMatch(uri::endsWith)) {
            return ProcessCodegen.SUPPORTED_SW_EXTENSIONS.keySet().stream().anyMatch(uri::endsWith);
        }
        return true;
    }

    private Optional<String> readFileContentFromClassPath(String relativeFileURI) {
        Optional<String> optional;
        block8: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/resources" + relativeFileURI);
            try {
                optional = Optional.of(IOUtils.toString((InputStream)is, (String)StandardCharsets.UTF_8.name()));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new SourceFilesException("Exception trying to read definition source file with relative URI:" + relativeFileURI, ex);
                }
            }
            is.close();
        }
        return optional;
    }
}

