/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesProviderImpl;

class SourceFilesProviderImplTest {
    private SourceFilesProviderImpl sourceFilesProvider;

    SourceFilesProviderImplTest() {
    }

    private static String readFileContent(String file) throws URISyntaxException, IOException {
        Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource(file).toURI());
        return Files.readString(path);
    }

    private String getTestFileContentByFilename(String fileName) throws URISyntaxException, IOException {
        return SourceFilesProviderImplTest.readFileContent("META-INF/resources/sources/" + fileName);
    }

    @BeforeEach
    public void setup() {
        this.sourceFilesProvider = new SourceFilesProviderImpl();
    }

    @Test
    void addSourceFile() {
        this.sourceFilesProvider.addSourceFile("a_process", this.createEmptySourceFile("myworkflow.sw.json"));
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).contains((Object[])new SourceFile[]{this.createEmptySourceFile("myworkflow.sw.json")});
    }

    @Test
    void getSourceFilesByProcessId() {
        this.sourceFilesProvider.addSourceFile("a_process", this.createEmptySourceFile("myworkflow.sw.json"));
        this.sourceFilesProvider.addSourceFile("a_process", this.createEmptySourceFile("myworkflow.sw.yaml"));
        this.sourceFilesProvider.addSourceFile("another_process", this.createEmptySourceFile("myanotherworkflow.sw.json"));
        this.sourceFilesProvider.addSourceFile("another_process", this.createEmptySourceFile("myanotherworkflow.sw.yaml"));
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{this.createEmptySourceFile("myworkflow.sw.json"), this.createEmptySourceFile("myworkflow.sw.yaml")});
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("another_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{this.createEmptySourceFile("myanotherworkflow.sw.json"), this.createEmptySourceFile("myanotherworkflow.sw.yaml")});
    }

    @Test
    void getSourceFilesByProcessIdShouldNotReturnNull() {
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).isEmpty();
    }

    @Test
    void getValidSourceFileDefinitionByProcessIdTest() throws Exception {
        this.sourceFilesProvider.addSourceFile("petstore_json_process", this.readSourceFile("petstore.json"));
        this.sourceFilesProvider.addSourceFile("petstore_sw_json_process", this.readSourceFile("petstore.sw.json"));
        this.sourceFilesProvider.addSourceFile("ymlgreet.sw_process", this.readSourceFile("ymlgreet.sw.yml"));
        this.sourceFilesProvider.addSourceFile("bpmn_process", this.readSourceFile("hiring.bpmn"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("petstore_sw_json_process")).contains((Object)this.getTestFileContentByFilename("petstore.sw.json"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("ymlgreet.sw_process")).contains((Object)this.getTestFileContentByFilename("ymlgreet.sw.yml"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("bpmn_process")).contains((Object)this.getTestFileContentByFilename("hiring.bpmn"));
    }

    @Test
    void getInvalidSourceFileDefinitionByProcessIdTest() throws URISyntaxException, IOException {
        this.sourceFilesProvider.addSourceFile("petstore_json_process", this.readSourceFile("petstore.json"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("petstore_json_process")).isEmpty();
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("invalidProcess")).isEmpty();
    }

    private SourceFile createEmptySourceFile(String uri) {
        return new SourceFile(uri, "");
    }

    private SourceFile readSourceFile(String uri) throws URISyntaxException, IOException {
        return new SourceFile(uri, this.getTestFileContentByFilename(uri));
    }
}

