/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.source.files;

import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addon.source.files.SourceFile;
import org.kie.kogito.addon.source.files.SourceFilesProviderImpl;

class SourceFilesProviderImplTest {
    private SourceFilesProviderImpl sourceFilesProvider;

    SourceFilesProviderImplTest() {
    }

    @BeforeEach
    public void setup() {
        this.sourceFilesProvider = new SourceFilesProviderImpl();
    }

    @Test
    void addSourceFile() {
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.json"));
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).contains((Object[])new SourceFile[]{new SourceFile("myworkflow.sw.json")});
    }

    @Test
    void getSourceFilesByProcessId() {
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.json"));
        this.sourceFilesProvider.addSourceFile("a_process", new SourceFile("myworkflow.sw.yaml"));
        this.sourceFilesProvider.addSourceFile("another_process", new SourceFile("myanotherworkflow.sw.json"));
        this.sourceFilesProvider.addSourceFile("another_process", new SourceFile("myanotherworkflow.sw.yaml"));
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{new SourceFile("myworkflow.sw.json"), new SourceFile("myworkflow.sw.yaml")});
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("another_process")).containsExactlyInAnyOrder((Object[])new SourceFile[]{new SourceFile("myanotherworkflow.sw.json"), new SourceFile("myanotherworkflow.sw.yaml")});
    }

    @Test
    void getSourceFilesByProcessIdShouldNotReturnNull() {
        Assertions.assertThat((Collection)this.sourceFilesProvider.getProcessSourceFiles("a_process")).isEmpty();
    }

    @Test
    void getValidSourceFileDefinitionByProcessIdTest() {
        SourceFile petstoreJson = new SourceFile("petstore.json");
        SourceFile petstoreSwJson = new SourceFile("petstore.sw.json");
        SourceFile ymlgreetSwYml = new SourceFile("ymlgreet.sw.yml");
        SourceFile hiringBpmn = new SourceFile("hiring.bpmn");
        this.sourceFilesProvider.addSourceFile("petstore_json_process", petstoreJson);
        this.sourceFilesProvider.addSourceFile("petstore_sw_json_process", petstoreSwJson);
        this.sourceFilesProvider.addSourceFile("ymlgreet.sw_process", ymlgreetSwYml);
        this.sourceFilesProvider.addSourceFile("bpmn_process", hiringBpmn);
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("petstore_sw_json_process")).contains((Object)petstoreSwJson);
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("ymlgreet.sw_process")).contains((Object)ymlgreetSwYml);
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("bpmn_process")).contains((Object)hiringBpmn);
    }

    @Test
    void getInvalidSourceFileDefinitionByProcessIdTest() {
        this.sourceFilesProvider.addSourceFile("petstore_json_process", new SourceFile("petstore.json"));
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("petstore_json_process")).isEmpty();
        Assertions.assertThat((Optional)this.sourceFilesProvider.getProcessSourceFile("invalidProcess")).isEmpty();
    }
}

