/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import java.net.URI;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobNotFoundException;
import org.kie.kogito.jobs.management.springboot.SpringRestJobsService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@ExtendWith(value={MockitoExtension.class})
public class SpringRestJobsServiceTest {
    public static final String CALLBACK_URL = "http://localhost";
    public static final String JOB_SERVICE_URL = "http://localhost:8085";
    private SpringRestJobsService tested;
    @Mock
    private RestTemplate restTemplate;

    @BeforeEach
    void setUp() {
        this.tested = new SpringRestJobsService(JOB_SERVICE_URL, CALLBACK_URL, this.restTemplate);
        this.tested.initialize();
    }

    @Test
    void testScheduleProcessJob() {
        ProcessJobDescription processJobDescription = ProcessJobDescription.of((ExpirationTime)ExactExpirationTime.now(), (Integer)1, (String)"processId");
        Assertions.assertThatThrownBy(() -> this.tested.scheduleProcessJob(processJobDescription)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testScheduleProcessInstanceJob() {
        Mockito.when((Object)this.restTemplate.postForEntity((URI)ArgumentMatchers.any(URI.class), ArgumentMatchers.any(Job.class), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)ResponseEntity.ok().build());
        ProcessInstanceJobDescription processInstanceJobDescription = ProcessInstanceJobDescription.of((long)123L, (ExpirationTime)ExactExpirationTime.now(), (String)"processInstanceId", (String)"processId");
        this.tested.scheduleProcessInstanceJob(processInstanceJobDescription);
        ArgumentCaptor jobArgumentCaptor = ArgumentCaptor.forClass(Job.class);
        ((RestTemplate)Mockito.verify((Object)this.restTemplate)).postForEntity((URI)ArgumentMatchers.eq((Object)this.tested.getJobsServiceUri()), jobArgumentCaptor.capture(), (Class)ArgumentMatchers.eq(String.class));
        Job job = (Job)jobArgumentCaptor.getValue();
        Assertions.assertThat((String)job.getId()).isEqualTo(processInstanceJobDescription.id());
    }

    @Test
    void testCancelJob() {
        this.tested.cancelJob("123");
        ((RestTemplate)Mockito.verify((Object)this.restTemplate)).delete(this.tested.getJobsServiceUri() + "/{id}", new Object[]{"123"});
    }

    @Test
    void testGetScheduleTime() {
        Job job = new Job();
        job.setId("123");
        job.setExpirationTime(ZonedDateTime.now());
        Mockito.when((Object)this.restTemplate.getForObject((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(), new Object[]{ArgumentMatchers.anyString()})).thenReturn((Object)job);
        ZonedDateTime scheduledTime = this.tested.getScheduledTime("123");
        Assertions.assertThat((ZonedDateTime)scheduledTime).isEqualTo((Object)job.getExpirationTime());
        ((RestTemplate)Mockito.verify((Object)this.restTemplate)).getForObject(this.tested.getJobsServiceUri() + "/{id}", Job.class, new Object[]{"123"});
    }

    @Test
    void testGetScheduleTimeJobNotFound() {
        Mockito.when((Object)this.restTemplate.getForObject((String)ArgumentMatchers.any(), (Class)ArgumentMatchers.any(), new Object[]{ArgumentMatchers.anyString()})).thenThrow(HttpClientErrorException.NotFound.class);
        Assertions.assertThatThrownBy(() -> this.tested.getScheduledTime("123")).isInstanceOf(JobNotFoundException.class);
        ((RestTemplate)Mockito.verify((Object)this.restTemplate)).getForObject(this.tested.getJobsServiceUri() + "/{id}", Job.class, new Object[]{"123"});
    }
}

