/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.springboot;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.kie.kogito.Application;
import org.kie.kogito.jobs.api.JobCallbackPayload;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.Processes;
import org.kie.kogito.services.jobs.impl.TriggerJobCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management/jobs"})
public class CallbackJobsServiceResource {
    @Autowired
    Processes processes;
    @Autowired
    Application application;
    @Autowired
    ObjectMapper objectMapper;

    @PostMapping(value={"{processId}/instances/{processInstanceId}/timers/{timerId}"}, produces={"application/json"})
    public ResponseEntity<String> triggerTimer(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="timerId") String timerId, @RequestParam(value="limit", defaultValue="0", required=false) Integer limit, @RequestBody String payload) {
        if (processId == null || processInstanceId == null) {
            return ResponseEntity.badRequest().body((Object)"Process id and Process instance id must be  given");
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("Process with id " + processId + " not found"));
        }
        String correlationId = null;
        if (payload != null && !payload.isBlank()) {
            try {
                JobCallbackPayload jobPayload = (JobCallbackPayload)this.objectMapper.readValue(payload, JobCallbackPayload.class);
                correlationId = jobPayload.getCorrelationId();
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Invalid payload: " + payload + ". " + e.getMessage()));
            }
        }
        return new TriggerJobCommand(processInstanceId, correlationId, timerId, limit, process, this.application.unitOfWorkManager()).execute() ? ResponseEntity.ok().build() : ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)("Process instance with id " + processInstanceId + " not found"));
    }
}

