/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.springboot.k8s;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
public class CachingConfig {
    public static final String CACHE_MANAGER = "caffeineCacheManager";

    @Bean
    public Caffeine<Object, Object> caffeineConfig() {
        return Caffeine.newBuilder();
    }

    @Primary
    @Bean(value={"caffeineCacheManager"})
    public CaffeineCacheManager cacheManager(Caffeine<Object, Object> caffeine) {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager(new String[]{"endpoint-by-name", "endpoint-by-labels"});
        cacheManager.setCaffeine(caffeine);
        return cacheManager;
    }
}

